/******************************************************************/
/*																						*/
/*	includes																			*/
/*																						*/
/******************************************************************/

#include <iapl.h>
#include <disp.h>

#include <iaplfull.h>

/******************************************************************/
/*																						*/
/* globals																			*/
/*																						*/
/******************************************************************/

static int row, col, rows, cols;
static DISPLAY_PARAMS display_params;

/******************************************************************/
/*																						*/
/* screen params																	*/
/*																						*/
/******************************************************************/

int fslimits (alpha, omega) int far *alpha; char far *omega;
{
	display_get_params (&display_params);

	alpha [0] = display_params.rows;
	alpha [1] = display_params.cols;

	return 1;
}

/******************************************************************/
/*																						*/
/* put to screen																	*/
/*																						*/
/******************************************************************/

int fsput (alpha, omega) int far *alpha; char far *omega;
{
	int rs, cs;
	register int r, c;

	for (r = row, rs = rows; rs--; r++)
		for (c = col, cs = cols; cs--; c++)
			display_put_char (r, c, (byte) *omega++);

	return 1;
}

/******************************************************************/
/*																						*/
/* get from screen																*/
/*																						*/
/******************************************************************/

int fsget (alpha, omega) int far *alpha; char far *omega;
{
	int rs, cs;
	register int r, c;

	for (r = row, rs = rows; rs--; r++)
		for (c = col, cs = cols; cs--; c++)
			*omega++ = (char) display_get_char (r, c);

	return 1;
}

/******************************************************************/
/*																						*/
/* screen fill																		*/
/*																						*/
/******************************************************************/

int fsfill (alpha, omega) int far *alpha; char far *omega;
{
	int rs, cs;
	register int r, c;
	byte x = (byte) *omega;

	for (r = row, rs = rows; rs--; r++)
		for (c = col, cs = cols; cs--; c++)
			display_put_char (r, c, x);

	return 1;
}

/******************************************************************/
/*																						*/
/* get/set cursor																	*/
/*																						*/
/******************************************************************/

int fscursor (alpha, omega) int far *alpha; char far *omega;
{
	display_move (row, col);

	alpha [0] = display_params.row;
	alpha [1] = display_params.col;

	return 1;
}

/******************************************************************/
/*																						*/
/* set window																		*/
/*																						*/
/******************************************************************/

int fswindow (alpha, omega) int far *alpha; char far *omega;
{
	display_set_window (row, col, rows, cols);

	return 1;
}

/******************************************************************/
/*																						*/
/* top level screen routine													*/
/*																						*/
/******************************************************************/

int screen (alpha, omega) ARRAY *alpha, *omega;
{
	typedef int (*FN) (int far *, char far *);

	static FN fns []=
	{
		fslimits, fsput, fsget, fsfill, fscursor, fswindow
	};

	int code = alpha->idata [0] - 200;
	int alpha_nels = *alpha->nels;
	FN fn = fns [code];

	if (code >= sizeof (fns) / sizeof (*fns) ||
		*omega->esize != 1 || *omega->rank > 2 ||
		(fn == fsfill || fn == fswindow ? alpha_nels != 5 : alpha_nels != 3))
				return 0;

	display_get_params (&display_params);

	row = display_params.row;
	col = display_params.col;

	if (alpha->idata [1] != -1 && alpha->idata [2] != -1)
	{
		row = alpha->idata [1];
		col = alpha->idata [2];
	}

	if (alpha_nels == 5)
	{
		rows = alpha->idata [3];
		cols = alpha->idata [4];
	}
	else if (!*omega->rank) rows = cols = 1;
	else if (*omega->rank == 1)
	{
		rows = 1;
		cols = omega->shape [0];
	}
	else
	{
		rows = omega->shape [0];
		cols = omega->shape [1];
	}

	return (int) (*fn) (alpha->idata + 1, omega->cdata);
}
