/******************************************************************/
/*																						*/
/*	includes																			*/
/*																						*/
/******************************************************************/

#include <stdio.h>
#include <string.h>
#include <io.h>
#include <dos.h>
#include <sys\types.h>
#include <sys\timeb.h>
#include <time.h>
#include <direct.h>
#include <process.h>
#include <stdlib.h>

#include <iapl.h>
#include <disp.h>
#include <iaplgraf.h>
#include <iaplfull.h>

/******************************************************************/
/*																						*/
/* file utilities																	*/
/*																						*/
/******************************************************************/

#define BUFFER_SIZE 512

int read_file (file, offset, dest, size)
	FILE *file;
	long offset;
	char far *dest;
	int size;
{
	char buffer [BUFFER_SIZE];
	register char *ptr;
	register int i;
	int n;
	int true_size = 0;

	if (file && (offset == -1 || !fseek (file, offset, 0)))
		while (size)
		{
			n = size < BUFFER_SIZE ? size : BUFFER_SIZE;
			true_size += i = fread (buffer, 1, n, file);
			size = i == n ? size - i : 0;
			for (ptr = buffer; i; i--) *dest++ = *ptr++;
		}

	return true_size;
}

int write_file (file, offset, source, size)
	FILE *file;
	long offset;
	char far *source;
	int size;
{
	char buffer [BUFFER_SIZE];
	int n;
	register char *ptr;
	register int i;
	int true_size = 0;

	if (file && (offset == -1 || !fseek (file, offset, 0)))
		while (size)
		{
			i = n = size < BUFFER_SIZE ? size : BUFFER_SIZE;
			for (ptr = buffer; i; i--) *ptr++ = *source++;
			true_size += i = fwrite (buffer, 1, n, file);
			size = i == n ? size - i : 0;
		}

	return true_size;
}

/******************************************************************/
/*																						*/
/* ws file primitives															*/
/*																						*/
/******************************************************************/

#define Z vs [2]				/* third item in value stack */
#define Y vs [1]				/* second item in value stack */
#define X vs [0]				/* top item in value stack */
#define W vs [-1]				/* item immediately above value stack */

FILE *ws_file = 0;			/* ws file handle */
int ws_file_size;				/* ws file size in bytes */
int ws_buffer_filled = 0;	/* flag for ws_buffer filled */
char ws_file_name [13];		/* ws file name */
char ws_buffer [32766];		/* ws buffer */

char *get_ws_file_name (buffer) char far *buffer;
{
	register char *ptr = ws_file_name;
	register int i;

	for (i = 8; i && *buffer != ' '; i--) *ptr++ = *buffer++;

	*ptr = 0;

	return strcat (ws_file_name, ".iws");
}

int far *ifopenr (vs, iapl) int far *vs; char far *iapl;
{
	if (ws_file) fclose (ws_file);

	ws_file = fopen (get_ws_file_name (iapl + X), "rb");
	X = ws_file && fread ((char *) &ws_file_size, 2, 1, ws_file);
	ws_buffer_filled = 0;

	return vs;
}

int far *ifopenw (vs, iapl) int far *vs; char far *iapl;
{
	if (ws_file) fclose (ws_file);

	ws_file = fopen (get_ws_file_name (iapl + X), "wb");
	X = ws_file != 0;
	ws_file_size = 0;
	ws_buffer_filled = 0;

	return vs;
}

int far *ifread (vs, iapl) int far *vs; char far *iapl;
{
	Y = ws_file &&
		ws_file_size <= X &&
		ws_file_size == read_file (ws_file, 2L, iapl + Y, ws_file_size);

	return vs + 1;
}

int far *ifwrite (vs, iapl) int far *vs; char far *iapl;
{
	int size = X;

	Y = ws_file &&
		!fseek (ws_file, 0L, 0) &&
		fwrite ((char *) &size, 2, 1, ws_file) &&
		size == write_file (ws_file, 2L, iapl + Y, size);

	if (Y) ws_file_size = size;

	return vs + 1;
}

int far *ifclose (vs, iapl) int far *vs; char far *iapl;
{
	W = ws_file && !fclose (ws_file);
	ws_file = 0;

	return vs - 1;
}

int far *ifreadr (vs, iapl) int far *vs; char far *iapl;
{
	char far *iapl_ptr = iapl + Z;
	register char *fb_ptr = ws_buffer + Y;
	register int i;

	Z = ws_file &&
		X + Y <= ws_file_size &&
			(ws_buffer_filled ||
				(ws_buffer_filled = !fseek (ws_file, 2L, 0) &&
					fread (ws_buffer, 1, ws_file_size, ws_file) == ws_file_size));

	if (Z) for (i = X; i; i--) *iapl_ptr++ = *fb_ptr++;

	return vs + 2;
}

int far *iferase (vs, iapl) int far *vs; char far *iapl;
{
	W = ws_file && !fclose (ws_file) && !unlink (ws_file_name);

	return vs - 1;
}

int far *ifdir (vs, iapl) int far *vs; char far *iapl;
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	unsigned int dta_seg, dta_offset;
	int found;
	char *ptr;
	char far *iapl_ptr;

	/* get current dta */

	inregs.h.ah = 0x2F;
	intdos (&inregs, &outregs);
	segread (&segregs);
	dta_seg = segregs.es;
	dta_offset = outregs.x.bx;

	/* set dta to dos_dta */

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* directory search */

	inregs.x.dx = (unsigned int) "*.IWS";
	inregs.h.ah = Y ? 0x4F : 0x4E;
	intdosx (&inregs, &outregs, &segregs);

	found = !outregs.x.cflag;	/* file found */

	/* restore original dta */

	segregs.ds = dta_seg;
	inregs.x.dx = dta_offset;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* copy file name to destination */

	Y = 0;

	if (found)
		for (ptr = dos_dta + 30, iapl_ptr = iapl + X; *ptr != '.'; Y++)
			*iapl_ptr++ = *ptr++;

	return vs + 1;
}

/******************************************************************/
/*																						*/
/* time																				*/
/*																						*/
/******************************************************************/

int far *itime (vs, iapl) int far *vs; char far *iapl; 
{
	int far *ptr = (int far *) (iapl + X);
	struct timeb t;
	struct tm *tp;

	ftime (&t);
	tp = localtime (&(long) t.time);

	ptr [0] = tp->tm_year + 1900;
	ptr [1] = tp->tm_mon + 1;
	ptr [2] = tp->tm_mday;
	ptr [3] = tp->tm_hour;
	ptr [4] = tp->tm_min;
	ptr [5] = tp->tm_sec;
	ptr [6] = (int) t.millitm;

	return vs;
}

/******************************************************************/
/*																						*/
/* wait																				*/
/*																						*/
/******************************************************************/

int far *iwait (vs, iapl) int far *vs; char far *iapl; 
{
	struct timeb t0, t1;

	ftime (&t0);
	t0.time += (time_t) X;

	while (ftime (&t1), Y && (t1.time < t0.time ||
		(t1.time == t0.time && t1.millitm < t0.millitm)))
			Y -= aplescape ();

	return vs;
}

/******************************************************************/
/*																						*/
/* user file interface															*/
/*																						*/
/******************************************************************/

#define SELECT 1
#define MAKE 2
#define OPEN 3
#define CLOSE 4
#define READ 5
#define WRITE 6
#define SIZE 7
#define CMD 8
#define TYPE 9
#define INBUF 10
#define INKEY 11

FILE *user_file = 0;

ARRAY get_array (ptr) char far *ptr;
{
	ARRAY array;

	array.type = (int far *) &ptr [0];
	array.esize = &ptr [2];
	array.rank = &ptr [3];
	array.nels = (int far *) &ptr [4];
	array.shape = (int far *) &ptr [6];
	array.idata = (int far *) &ptr [6] + *array.rank;
	array.cdata = (char far *) array.idata;

	return array;
}

char *get_string (string, size) char far *string; int size;
{
	static char buffer [BUFFER_SIZE];
	register char *ptr = buffer;
	register int i;

	if (!size || size >= BUFFER_SIZE) return 0;

	for (i = size; i; i--) *ptr++ = *string++;
	*ptr = 0;

	return buffer;
}

int far *ifuser (vs, iapl) int far *vs; char far *iapl;
{
	ARRAY alpha, omega;

	static int convert [7] [7] =
	{
		{-1, -8, -16, 0, 0, 0, -48},
		{8, -1, -2, 0, 0, 0, -6},
		{16, 2, -1, 0, 0, 0, -3},
		{0},
		{0},
		{0},
		{48, 6, 3, 0, 0, 0, -1}
	};

	register int code = 0;
	register char *mode = "r+b";
	char *ptr;
	int far *last;
	int n;
	long size, posn;

	alpha = get_array (iapl + *(int far *) (iapl + Y));
	omega = get_array (iapl + *(int far *) (iapl + Y + 2));

	if (Y = X == 2 && *alpha.type == 'n' && *alpha.esize == 2 &&
		*alpha.rank <= 1 && *alpha.nels)
	{
		if (alpha.idata [0] >= 100 && alpha.idata [0] < 200)
			Y = graphics (&alpha, &omega);
		else if (alpha.idata [0] >= 200 && alpha.idata [0] < 300)
			Y = screen (&alpha, &omega);
		else
		{
			if (Y = alpha.idata [0] == INKEY && *alpha.nels > 1)
			{
				if (!(alpha.idata [1] = mygetch ())) alpha.idata [1] = -mygetch ();
				code = 1;
			}
			else if (Y = alpha.idata [0] == TYPE && *alpha.nels > 1)
			{
				switch (alpha.idata [1])
				{
				case -1:
					alpha.idata [1] = (int) *omega.esize;
					code = 1;
					break;

				case 0:
				case 1:
				case 2:
				case 6:
					if (Y = *omega.rank != 0)
					{
						last = omega.idata - 1;
						n = convert [*omega.esize] [alpha.idata [1]];

						if (n < 0)
						{
							n = -n;
							if (code = *last % n == 0) *last /= n, *omega.nels /= n;
						}
						else if (code = n * *last < 32767 && n * *omega.nels < 32767)
								*last *= n, *omega.nels *= n;

						if (Y = code)
						{
							*omega.esize = (char) alpha.idata [1];
							*omega.type = alpha.idata [1] == 1 ? 'c' : 'n';
						}
					}

					break;
				}

				alpha.idata [0] = code;
			}
			else if (Y = *omega.type == 'c' && *omega.rank <= 1)
			{
				switch (alpha.idata [0])
				{
				case SELECT:
					if (Y = (ptr = get_string (omega.cdata, *omega.nels)) != 0)
						code = !chdir (ptr);
					break;

				case MAKE:
					mode = "w+b";

				case OPEN:
					if (Y = (ptr = get_string (omega.cdata, *omega.nels)) != 0)
					{
						if (user_file) fclose (user_file);
						user_file = fopen (ptr, mode);
						code = user_file ? !fseek (user_file, 0L, 0) : 0;
					}
					break;

				case CLOSE:
					if (user_file) fclose (user_file);
					user_file = 0;
					code = 1;
					break;

				case READ:
					if (Y = user_file != 0 && *alpha.nels > 1)
					{
						omega.shape [0] = *omega.nels =
							read_file (user_file, (long) alpha.idata [1],
								omega.cdata, *omega.nels);
						code = 1;
					}
					break;

				case WRITE:
					if (Y = user_file != 0 && *alpha.nels > 1)
					{
						alpha.idata [1] =
							write_file (user_file, (long) alpha.idata [1],
								omega.cdata, *omega.nels);
						code = 1;
					}
					break;

				case SIZE:
					if (Y = user_file != 0 && *alpha.nels > 1)
					{
						posn = ftell (user_file);
						if (fseek (user_file, 0L, 2)) break;
						size = ftell (user_file);
						if (fseek (user_file, posn, 0)) break;
						if (size > 32767) break;
						alpha.idata [1] = (int) size;
						code = 1;
					}
					break;

				case CMD:
					if (*omega.nels)
					{
						ptr = get_string (omega.cdata, *omega.nels);
						if (ptr) code = !system (ptr);
					}
					else if (ptr = getenv ("COMSPEC"))
					{
						display_clear ();
						code = !system (ptr);
						display_init (0, 0);
					}
					break;

				case INBUF:
					if (*alpha.nels > 1 && alpha.idata [1] >= -1 &&
						alpha.idata [1] <= 1 &&
						(ptr = get_string (omega.cdata, *omega.nels)))
							code = aplinsert (ptr, *omega.nels, alpha.idata [1]);
					break;
				}

				alpha.idata [0] = code;
			}
		}
	}

	return vs + 1;
}
