/******************************************************************/
/*																						*/
/*	includes																			*/
/*																						*/
/******************************************************************/

#include <stdio.h>
#include <conio.h>
#include <memory.h>
#include <string.h>
#include <io.h>
#include <dos.h>
#include <signal.h>
#include <ctype.h>
#include <process.h>
#include <stdlib.h>

#include <iapl.h>
#include <font.h>
#include <overstr.h>
#include <iaplgraf.h>
#include <disp.h>

/******************************************************************/
/*																						*/
/*	manifest constants															*/
/*																						*/
/******************************************************************/

#define byte unsigned char

#define BS 8
#define TAB 9
#define LF 10
#define CR 13
#define ESC 27

#define SESSION_FILE_NAME "iapl.ses"

/******************************************************************/
/*																						*/
/*	globals																			*/
/*																						*/
/******************************************************************/

void iaplloop (int);							/* assembler loop */

char display_code = 'Z';					/* display code (default = text ROM) */
char printer_code = 'P';					/* printer code (default = ASCII) */
char scale_code = '0';						/* graphics scale factor */

int soft_scroll = 0;							/* soft scroll */
int record = 0;								/* session recording */

char dos_dta [128];							/* dos data transfer area */

int kb_pending = 0;

byte kb_buffer [256];
byte kb_ptr = 0;
byte kb_size = 0;

char kbd_status;

char *help [] =
{
	"Each argument must be either a workspace file to be loaded, or a '/'",
	"followed by one or more of the following flags:",
	"  Display:",
	"    A  ASCII transliteration",
	"    C  APL symbols using 640 by 200 CGA graphics",
	"    H  APL symbols using hercules graphics",
	"    M  APL symbols using 320 by 200 CGA graphics",
	"    N  APL symbols using 640 by 350 EGA graphics (256KB EGA RAM required)",
	"    X  APL symbols using EGA text",
	"    Z  APL symbols from APL ROM on text display (default)",
	"  Printing:",
	"    B  Bit-paired APL printer",
	"    E  EPSON printer using downloaded font (see EPSON workspace)",
	"    G  EPSON printer using graphics",
	"    P  ASCII transliteration (default)",
	"    T  Typewriter-paired APL printer",
	"  Miscellaneous:",
	"    n  (n = 0-9) coarsen graphics by a factor of 2*n",
	"    D  Software scroll (use with C or M on EGA and some CGA clones)",
	"    S  Append all characters typed to file IAPL.SES (debugging aid)",
	0
};

/******************************************************************/
/*																						*/
/*	initial entry point															*/
/*																						*/
/******************************************************************/

void main (argc, argv) int argc; char *argv [];
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	FILE *file;
	int i;
	char *env, *token;
	char far *kbd_status_ptr = (char far *) 0x417l;

	signal (SIGINT, SIG_IGN);

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	if (env = getenv ("IAPL"))
		for (token = strtok (env, " ,"); token; token = strtok (0, " ,"))
			treat_arg (token);

	for (i = 1; i < argc; i++) treat_arg (argv [i]);

	if (record)
	{
		file = fopen (SESSION_FILE_NAME, "at");
		if (file)
		{
			fprintf (file, "\f\f\f\f\n");
			fclose (file);
		}
	}

	display_init (display_code, soft_scroll);
	graphics_init (display_code, scale_code);

	kbd_status = *kbd_status_ptr;
	*kbd_status_ptr |= 0x40;

	iaplloop (display_code == 'H' ? 12 :
			display_code == 'C' ? 24 :
			display_code == 'X' ? 36 :
			display_code == 'M' ? 48 :
			display_code == 'N' ? 60 : 0);

	*kbd_status_ptr = kbd_status;

	display_clear ();
}

/******************************************************************/
/*																						*/
/*	process command line argument												*/
/*																						*/
/******************************************************************/

void treat_arg (arg) char *arg;
{
	char **help_ptr;
	char *ptr;
	char c;

	if (*arg == '?')
	{
		for (help_ptr = help; *help_ptr; help_ptr++)
			printf ("%s\n", *help_ptr);

		exit (0);
	}
	else if (*arg == '/')
		for (ptr = arg + 1; *ptr; ptr++)
			switch (c = (char) toupper ((int) *ptr))
			{
			case 'A':
			case 'C':
			case 'H':
			case 'M':
			case 'N':
			case 'X':
			case 'Z':
				display_code = c;
				break;

			case 'B':
			case 'E':
			case 'P':
			case 'G':
			case 'T':
				printer_code = c;
				break;

			case 'S':
				record = 1;
				break;

			case 'D':
				soft_scroll = 1;
				break;

			default:
				if (c >= '0' && c <= '9') scale_code = c;
				else
				{
					printf ("Illegal flag\n");
					exit (0);
				}
				break;
			}
	else
	{
		if (strlen (arg) > 8)
		{
			printf ("Illegal workspace file name\n");
			exit (0);
		}

		aplinsert (")LOAD ", 6, 0);

		for (ptr = arg; *ptr; ptr++)
			if (isalpha ((int) *ptr) ||
				isdigit ((int) *ptr) && ptr != arg)
			{
				c = (char) toupper ((int) *ptr);
				aplinsert (&c, 1, -1);
			}
			else
			{
				printf ("Illegal workspace file name\n");
				exit (0);
			}

		aplinsert ("\r", 1, -1);
	}
}

/******************************************************************/
/*																						*/
/*	record character in session file											*/
/*																						*/
/******************************************************************/

void record_char (c) register int c;
{
	static char record_buffer [80];
	static int record_count = 0;
	register FILE *file;

	if (!record) return;

	if (c == CR || record_count == 80)
	{
		file = fopen (SESSION_FILE_NAME,"at");
		if (file)
		{
			fwrite (record_buffer, 1, record_count, file);
			fputc (c == CR ? LF : c, file);
			fclose (file);
		}
		record_count = 0;
	}
	else record_buffer [record_count++] = (char) c;
}

/******************************************************************/
/*																						*/
/*	insert characters into kb buffer											*/
/*																						*/
/******************************************************************/

int aplinsert (ptr, size, code)
	register char *ptr;
	register int size;
	int code;
{
	if (!code) kb_size = 0;

	if ((int) kb_size + size > 255)
	{
		kb_size = 0;
		return 0;
	}

	if (code == 1)
	{
		kb_size += (byte) size;
		while (size--) kb_buffer [--kb_ptr] = (byte) ptr [size];
	}
	else while (size--) kb_buffer [kb_ptr + kb_size++] = (byte) *ptr++;

	return 1;
}

/******************************************************************/
/*																						*/
/*	check for escape																*/
/*																						*/
/******************************************************************/

int aplescape ()
{
	int c;

	if (kb_pending)
	{
		kb_pending -= 1;
		while (kbhit ()) getch ();
		kb_size = 0;
		return 1;
	}

	while (kb_size != 255)
	{
		if (!kbhit ()) return 0;
		c = getch ();
		if (c == ESC)
		{
			while (kbhit ()) getch ();
			display_reset_window ();
			kb_size = 0;
			return 1;
		}
		kb_buffer [(byte) (kb_ptr + kb_size)] = (byte) c;
		kb_size += 1;
	}

	return 0;
}

/******************************************************************/
/*																						*/
/*	get number of escapes pending												*/
/*																						*/
/******************************************************************/

int aplpending (flag) int flag;
{
	if (flag)
	{
		flag = aplescape ();
		kb_pending += flag;
	}

	return kb_pending;
}

/******************************************************************/
/*																						*/
/*	get character and record if required									*/
/*																						*/
/******************************************************************/

int mygetch ()
{
	register int c;

	if (kb_size)
	{
		kb_size -= 1;
		c = (int) (kb_buffer [kb_ptr++]);
	}
	else
	{
		display_xcursor ();
		c = getch ();
		display_xcursor ();
	}

	record_char (c);
	return c;
}

/******************************************************************/
/*																						*/
/*	get character and convert to iapl										*/
/*																						*/
/******************************************************************/

#define INS 82
#define DEL 83
#define CUL 75
#define CUR 77
#define HOME 71
#define END 79
#define BACKTAB 15
#define CCUL 115
#define CCUR 116
#define ALT1 120
#define ALT2 121
#define ALT3 122
#define ALT4 123
#define ALT5 124
#define ALT6 125
#define ALT7 126
#define ALT8 127
#define ALT9 128
#define ALT0 129

int aplgetch ()
{
	static int cr_pending = 0;
	static char saved_kbd_status;
	static int ascii_input = 0;
	static int xlate [] [2] =
	{
		{CUL, 1}, {CUR, 2}, {HOME, 3}, {END, 4}, {CCUL, 5}, {CCUR, 6},
		{BACKTAB, 7}, {DEL, 0x7F},
		{ALT1, 0x95}, {ALT2, 0xB8}, {ALT3, 0x96}, {ALT4, 0xE0},
		{ALT5, 0xC0},
		{ALT6, 0xFD}, {ALT7, 0xFE},
		{ALT9, 0xA6}, {ALT0, 0xA8},
		{0, 0}
	};

	register int i;
	register int c;
	char far *kbd_status_ptr = (char far *) 0x417l;

	if (cr_pending)
	{
		cr_pending = 0;
		return CR;
	}

	c = mygetch ();

	if (c == CR)
	{
		cr_pending = 1;
		return 4;
	}

	if (c)
	{
		if (c == ESC) display_reset_window ();
		return c == BS || c == ESC || c == TAB ? c :
			c < ' ' ? 0 :
			ascii_input ? c | (c << 8) : c;
	}
	else
	{
		c = mygetch ();
		if (c == INS)
 		{
			ascii_input = ~ascii_input;

  			if (ascii_input)
			{
				saved_kbd_status = *kbd_status_ptr;
				*kbd_status_ptr = kbd_status;
			}
			else *kbd_status_ptr = saved_kbd_status;
		}

		for (i = 0; xlate [i] [0]; i++)
			if (c == xlate [i] [0]) return xlate [i] [1];

		return 0;
	}
}

/******************************************************************/
/*																						*/
/*	convert apl char and display												*/
/*																						*/
/******************************************************************/

void aplputch (c) int c;
{
	register byte apl = (byte) (c >> 8);
	register byte ascii = (byte) c;

	if (apl || display_code == 'C' || display_code == 'H' ||
		display_code == 'M' || display_code == 'N')
			display_putch (c);
		else
		{
			display_xcursor ();
			putch ((int) ascii);
			display_xcursor ();
		}
}

/******************************************************************/
/*																						*/
/*	print char																		*/
/*																						*/
/******************************************************************/

void gprint (c) register int c;
{
	static struct {char x [2]; int count;} msg = {{ESC, 'L'}, 0};
	static byte buffer [96];
	static int index = 0;
	byte *ptr;
	int i, j, n;
	byte m;

	if (!c && index || index == 96)
	{
		msg.count = index * 10;
		write (4, (char *) &msg, 4);

		for (n = 0; n < index; n++)
		{
			for (i = 7; i >= 0; i--)
			{
				for (m = 0, ptr = cga_font [buffer [n]], j = 7; j; j--)
					m = m << 1 | *ptr++ >> i & 1;
				write (4, (char *) &m, 1);
			}
			write (4, "\0\0", 2);
		}

		index = 0;
	}

	if (c) buffer [index++] = (byte) c;
}

/******************************************************************/
/*																						*/
/*	print graphics char															*/
/*																						*/
/******************************************************************/

void aplprint (c) int c;
{
	int a = (c >> 8) & 0xFF;

	if (!a || a == CR)
	{
		if (printer_code == 'G') gprint (0);

		if (!a) write (4, (char *) &c, 1);
		else write (4, "\r\n", 2);
	}
	else if (printer_code == 'B' || printer_code == 'T')
	{
		write (4, (char *) overstrike_table [printer_code == 'T'] [a], 1);
		a = (int) overstrike_table [printer_code == 'T'] [a] [1];
		if (a != ' ') write (4, "\b", 1), write (4, (char *) &a, 1);
	}
	else if (printer_code == 'G') gprint (a);
	else if (printer_code == 'E')
	{
		if (a >= 0x97 && a <= 0x9E) a = 0x9F;
		if (a == 0xFF) a = 0x9E;
		write (4, (char *) &a, 1);
	}
	else write (4, (char *) &c, 1);
}
