#include <conio.h>

#include <iapl.h>
#include <font.h>
#include <disp.h>
#include <graphics.h>

#include <htext.h>

#define CRTC_INDEX 0x3B4
#define CONTROL 0x3B8
#define STATUS 0x3BA

int hercules_addr_offset;
int hercules_offset_table [29] [12];

void hercules_set_mode (ptr) int *ptr;
{
	int far *address;
	register int i;
	register int store;

	while (!(inp (STATUS) & 0x80));
	while (inp (STATUS) & 0x80);

	outp (0x03B8, *ptr++);

	for (i = 0; i < 14; i++) outpw (CRTC_INDEX, (int) i, *ptr++);

	for (address = (int far *) 0xB0000000, store = *ptr++, i = *ptr++; i--; )
		*address++ = store;

	outp (CONTROL, *ptr);
}

void hercules_clear_graphics ()
{
	static int table [] =
	{
		0x02,
		0x35, 0x2D, 0x2E, 0x07,
		0x5B, 0x02, 0x57, 0x57,
		0x02, 0x03, 0x00, 0x00,
		0x00, 0x00,
		0,
		16384,
		0x0A
	};

	register int row, line;

	hercules_set_mode (table);

	for (row = 0; row < 29; row++)
		for (line = 0; line < 12; line++)
			hercules_offset_table [row] [line] = 90 * (3 * row + (line >> 2));

	hercules_addr_offset = 0;
}

void hercules_clear_text ()
{
	static int table [] =
	{
		0x20,
		0x61, 0x50, 0x52, 0x0F,
		0x19, 0x06, 0x19, 0x19,
		0x02, 0x0D, 0x0B, 0x0C,
		0x00, 0x00,
		0x0720,
		2000,
		0x28
	};

	hercules_set_mode (table);
}

#define SCREEN(ROW,LINE,COL)														\
	((byte far *) (0xB0000000 +													\
		((hercules_addr_offset +													\
		hercules_offset_table [ROW] [LINE] + (COL)) & 0x1FFF) +			\
		(((LINE) & 3) << 13)))

int hercules_display (code, row, col, n) int code, row, col, n;
{
	static int crtc_offset = 0;
	byte far *sptr, far *dptr;
	register int line, j;
	byte x;
	int i;

	switch (code)
	{
	case DISPLAY_COPY_LINE:
		dptr = SCREEN (row, 0, col);
		sptr = SCREEN (row + 1, 0, col);

		if (((unsigned int) sptr + 270 & 0x2000) ||
			((unsigned int) dptr + 270 & 0x2000))
		{
			for (line = 12; line--;)
				for (j = col; j < col + n; j++)
				{
					x = *SCREEN (row + 1, line, j);
					*SCREEN (row, line, j) = x;
				}
		}
		else
		{
			for (i = 4; i--; )
			{
				for (line = 3; line--; )
				{
					for (j = n; j--; ) *dptr++ = *sptr++;
					sptr += 90 - n;
					dptr += 90 - n;
				}

				sptr += 0x2000 - 270;
				dptr += 0x2000 - 270;
			}
		}

		break;

	case DISPLAY_CLEAR_LINE:
		for (line = 12; line--; )
			for (j = col, i = n; i--; j++)
				*SCREEN (row, line, j) = 0;

		break;

	case DISPLAY_SCROLL:
		hercules_addr_offset += 270;
		hercules_display (DISPLAY_CLEAR_LINE, 28, 0, 90);
		crtc_offset += 135;
		outpw (CRTC_INDEX, 12, crtc_offset >> 8);
		outpw (CRTC_INDEX, 13, crtc_offset & 0xFF);
		break;

	case DISPLAY_CHAR:
		for (line = 11; line--; )
		{
			x = hercules_font [n] [line];
			*SCREEN (row, line, col) = x;
		}

		*SCREEN (row, 11, 0) = 0;

		break;

	case DISPLAY_XCURSOR:
		*SCREEN (row, 11, col) ^= 127;
		break;
	}

	return 0;
}

DISPLAY_INFO hercules_init (iapl) int iapl;
{
	DISPLAY_INFO display_info;

	if (iapl) hercules_clear_graphics ();
	else hercules_clear_text ();

	display_info.routine = hercules_display;
	display_info.rows = 29;
	display_info.cols = 90;

	return display_info;
}
