		TITLE   graphics

_TEXT		SEGMENT  BYTE PUBLIC 'CODE'
_TEXT		ENDS
CONST		SEGMENT  WORD PUBLIC 'CONST'
CONST		ENDS
_BSS		SEGMENT  WORD PUBLIC 'BSS'
_BSS		ENDS
_DATA		SEGMENT  WORD PUBLIC 'DATA'
_DATA		ENDS

DGROUP		GROUP	CONST,_BSS,_DATA

		ASSUME  CS:_TEXT,DS:DGROUP,SS:DGROUP,ES:DGROUP

;******************************************************************************

; c routine entry code

C_ENTRY		macro	NAME

		PUBLIC	NAME
NAME		PROC	NEAR

	push	bp
	mov	bp,sp

		endm

;******************************************************************************

; c routine exit code

C_EXIT		macro	NAME

	pop	bp
	ret

NAME		ENDP

		endm

;******************************************************************************

; calculate hercules screen address from arguments
; on exit:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
;	ax,dx = ?

HERCULES_ADDR	macro

	mov	ax,0B000h
	mov	es,ax		; screen segment

	mov	ax,347
	sub	ax,argy		; ax = y measured from top of screen
	mov	bx,ax		; bx = y

	shr	ax,1
	and	al,0FEh		; ax = 2 * (y >> 2)
	mov	cx,ax
	add	ax,ax		; 4 *
	add	ax,ax		; 8 *
	add	cx,ax		; 10 *
	add	ax,ax		; 16 *
	add	cx,ax		; 26 *
	add	ax,ax		; 32 *
	add	ax,ax		; 64 *
	add	ax,cx		; 90 * (y >> 2)

	mov	dx,argx
	mov	cl,3
	shr	dx,cl		; x >> 3
	add	ax,dx

	add	ax,_hercules_addr_offset

	and	ax,1FFFh

	and	bx,3
	mov	cl,13
	shl	bx,cl
	add	bx,ax		; es:[bx] = screen address

	mov	cx,argx
	not	cl
	and	cl,7		; cl = shift
	mov	ch,1
	shl	ch,cl		; ch = mask

		endm

;******************************************************************************

; calculate cga screen address from arguments
; on exit:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
;	ax,dx = ?

CGA_ADDR	macro

	mov	ax,0B800h
	mov	es,ax		; screen segment

	mov	ax,199
	sub	ax,argy		; ax = y measured from top of screen
	mov	bx,ax		; bx = y

	and	al,0FEh		; ax = 2 * (y >> 1)
	add	ax,ax		; 4 *
	add	ax,ax		; 8 *
	add	ax,ax		; 16 *
	mov	cx,ax		; 16 *
	add	ax,ax		; 32 *
	add	ax,ax		; 64 *
	add	ax,cx		; 80 * (y >> 1)

	mov	dx,argx
	mov	cl,3
	shr	dx,cl		; x >> 3
	add	ax,dx

	add	ax,_cga_addr_offset

	and	ax,1FFFh

	and	bx,1
	mov	cl,13
	shl	bx,cl
	add	bx,ax		; es:[bx] = screen address

	mov	cx,argx
	not	cl
	and	cl,7		; cl = shift
	mov	ch,1
	shl	ch,cl		; ch = mask

		endm

;******************************************************************************

; calculate mga screen address from arguments
; on exit:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
;	ax,dx = ?

MGA_ADDR	macro

	mov	ax,0B800h
	mov	es,ax		; screen segment

	mov	ax,199
	sub	ax,argy		; ax = y measured from top of screen
	mov	bx,ax		; bx = y

	and	al,0FEh		; ax = 2 * (y >> 1)
	add	ax,ax		; 4 *
	add	ax,ax		; 8 *
	add	ax,ax		; 16 *
	mov	cx,ax		; 16 *
	add	ax,ax		; 32 *
	add	ax,ax		; 64 *
	add	ax,cx		; 80 * (y >> 1)

	mov	dx,argx
	shr	dx,1
	shr	dx,1		; x >> 2
	add	ax,dx

	add	ax,_cga_addr_offset

	and	ax,1FFFh

	and	bx,1
	mov	cl,13
	shl	bx,cl
	add	bx,ax		; es:[bx] = screen address

	mov	cx,argx
	not	cl
	and	cl,3
	add	cl,cl		; cl = shift
	mov	ch,3
	shl	ch,cl		; ch = mask

		endm

;******************************************************************************

; calculate ega screen address from arguments
; on exit:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
;	dx = graphics port address
;	ax = ?

EGA_ADDR	macro

	mov	ax,0A000h
	mov	es,ax		; screen segment

	mov	ax,349
	sub	ax,argy		; ax = y measured from top of screen

	add	ax,ax		; ax = 2 * y
	add	ax,ax		; 4 *
	add	ax,ax		; 8 *
	add	ax,ax		; 16 *
	mov	cx,ax		; 16 *
	add	ax,ax		; 32 *
	add	ax,ax		; 64 *
	add	ax,cx		; 80 * y

	mov	bx,argx
	mov	cl,3
	shr	bx,cl		; x >> 3
	add	bx,ax

	add	bx,_ega_addr_offset
				; es:[bx] = screen address

	mov	cx,argx
	not	cl
	and	cl,7		; cl = shift
	mov	ch,1
	shl	ch,cl		; ch = mask

	mov	dx,3CEh		; dx = graphics port address

		endm

;******************************************************************************

; plot pixel
; on entry:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
; on exit:
;	ax,cx,dx = ?

PLOT		macro

	mov	dh,argf
	mov	dl,argt
	shl	dx,cl		; dh = f, dl = t

	mov	cl,es:[bx]	; ch = m, cl = s

	mov	ax,cx
	not	ax		; ah = ~m, al = ~s

	or	ah,dl
	and	ah,cl		; s ^ (~m | t)

	and	al,ch
	and	al,dh		; ~s & m & f

	or	al,ah
	mov	es:[bx],al

		endm

;******************************************************************************

; get pixel
; on entry:
;	es:[bx] = screen byte
;	ch = bit mask
;	cl = bit number
; on exit:
;	ax = pixel colour

GET		macro

	xor	ah,ah
	mov	al,es:[bx]
	and	al,ch
	shr	al,cl

		endm

;******************************************************************************

_DATA		SEGMENT

		EXTRN	_hercules_addr_offset:word
		EXTRN	_cga_addr_offset:word
		EXTRN	_ega_addr_offset:word

_DATA		ENDS

;******************************************************************************

_TEXT		SEGMENT

;******************************************************************************

argport		EQU	word ptr [bp+4]
argindex	EQU	byte ptr [bp+6]
argdata		EQU	byte ptr [bp+8]

;******************************************************************************

; output word to port

	C_ENTRY	_outpw

	mov	dx,argport
	mov	al,argindex
	mov	ah,argdata
	out	dx,ax

	C_EXIT	_outpw

;******************************************************************************

argx		EQU	word ptr [bp+4]
argy		EQU	word ptr [bp+6]
argf		EQU	byte ptr [bp+8]
argt		EQU	byte ptr [bp+10]

;******************************************************************************

; plot pixel (x, y) according to f and t on hercules

	C_ENTRY	_hercules_plot
	HERCULES_ADDR
	PLOT
	C_EXIT	_hercules_plot

;******************************************************************************

; get colour of pixel (x, y) from hercules

	C_ENTRY	_hercules_get
	HERCULES_ADDR
	GET
	C_EXIT	_hercules_get

;******************************************************************************

; plot pixel (x, y) according to f and t on cga

	C_ENTRY	_cga_plot
	CGA_ADDR
	PLOT
	C_EXIT	_cga_plot

;******************************************************************************

; get colour of pixel (x, y) from cga

	C_ENTRY	_cga_get
	CGA_ADDR
	GET
	C_EXIT	_cga_get

;******************************************************************************

; plot pixel (x, y) according to f and t on mga

	C_ENTRY	_mga_plot
	MGA_ADDR
	PLOT
	C_EXIT	_mga_plot

;******************************************************************************

; get colour of pixel (x, y) from mga

	C_ENTRY	_mga_get
	MGA_ADDR
	GET
	C_EXIT	_mga_get

;******************************************************************************

GRAPHICS_SET_RESET		EQU	0
GRAPHICS_ENABLE_SET_RESET	EQU	1
GRAPHICS_FUNCTION		EQU	3
GRAPHICS_READ_MAP_SELECT	EQU	4
GRAPHICS_MODE			EQU	5
GRAPHICS_MASK			EQU	8

;******************************************************************************

; plot pixel (x, y) according to f and t on ega

	C_ENTRY	_ega_plot
	EGA_ADDR

; set graphics registers

	mov	ax,200h+GRAPHICS_MODE
	out	dx,ax		; write mode 2

	mov	al,GRAPHICS_MASK
	mov	ah,ch
	out	dx,ax		; graphics mask

; write pixel

	mov	cl,argf
	mov	ch,argt
	xor	ch,cl

	mov	ax,800h+GRAPHICS_FUNCTION
	out	dx,ax		; and

	mov	al,es:[bx]	; load latches
	mov	es:[bx],ch	; s = s & (f ^ t)

	mov	ax,1800h+GRAPHICS_FUNCTION
	out	dx,ax		; xor

	mov	al,es:[bx]	; load latches
	mov	es:[bx],cl	; s = s ^ f

; restore graphics registers

	mov	ax,GRAPHICS_FUNCTION
	out	dx,ax
	mov	ax,GRAPHICS_MODE
	out	dx,ax
	mov	ax,0FF00h+GRAPHICS_MASK
	out	dx,ax

	C_EXIT	_ega_plot

;******************************************************************************

; get colour of pixel (x, y) from ega

	C_ENTRY	_ega_get
	EGA_ADDR

	mov	cl,0

	mov	ax,300h+GRAPHICS_READ_MAP_SELECT
	out	dx,ax
	test	es:[bx],ch
	jz	eget1

	or	cl,8

eget1:	dec	ah
	out	dx,ax
	test	es:[bx],ch
	jz	eget2

	or	cl,4

eget2:	dec	ah
	out	dx,ax
	test	es:[bx],ch
	jz	eget3

	or	cl,2

eget3:	dec	ah
	out	dx,ax
	test	es:[bx],ch
	jz	eget4

	or	cl,1

eget4:	mov	al,cl

	C_EXIT	_ega_get

;******************************************************************************

_TEXT		ENDS

;******************************************************************************

		END
