#include <dos.h>

#include <iapl.h>
#include <font.h>
#include <disp.h>
#include <graphics.h>

#include <etext.h>

#define CRTC_INDEX 0x3D4

int ega_addr_offset;
int ega_offset_table [25] [14];

void ega_clear_graphics ()
{
	union REGS regs;
	register int row, line;

	regs.x.ax = (unsigned int) 0x10;
	int86 (0x10, &regs, &regs);

	for (row = 0; row < 25; row++)
		for (line = 0; line < 14; line++)
			ega_offset_table [row] [line] = 80 * (14 * row + line);

	ega_addr_offset = 0;
}

#define SCREEN(ROW,LINE,COL)																	\
	((byte far *)																					\
		(0xA0000000 + (unsigned long) (unsigned int)										\
			(ega_addr_offset + ega_offset_table [ROW] [LINE] + (COL))				\
		)																								\
	)

int ega_display (code, row, col, n) int code, row, col, n;
{
	static int crtc_offset;
	byte far *sptr, far *dptr;
	register int line;
	byte x;
	int i;

	switch (code)
	{
	case DISPLAY_COPY_LINE:
		outpw (GRAPHICS_INDEX, GRAPHICS_MODE, 1);

		dptr = SCREEN (row, 0, col);
		sptr = SCREEN (row + 1, 0, col);

		for (line = 14; line--; )
		{
			for (i = n; i--; ) *dptr++ = *sptr++;
			sptr += 80 - n;
			dptr += 80 - n;
		}

		outpw (GRAPHICS_INDEX, GRAPHICS_MODE, 0);
		break;

	case DISPLAY_CLEAR_LINE:
		dptr = SCREEN (row, 0, col);

		for (line = 14; line--; )
		{
			for (i = n; i--; ) *dptr++ = 0;
			dptr += 80 - n;
		}

		break;

	case DISPLAY_SCROLL:
		ega_addr_offset += 14 * 80;
		ega_display (DISPLAY_CLEAR_LINE, 24, 0, 80);
		crtc_offset += 14 * 80;
		outpw (CRTC_INDEX, 12, crtc_offset >> 8);
		outpw (CRTC_INDEX, 13, crtc_offset & 0xFF);
		break;

	case DISPLAY_CHAR:
		dptr = SCREEN (row, 0, col);

		for (line = 0; line < 11; line++)
		{
			*dptr = hercules_font [n] [line];
			dptr += 80;
		}

		for (line = 3; line--; )
		{
			*dptr = 0;
			dptr += 80;
		}

		break;

	case DISPLAY_XCURSOR:
		outpw (GRAPHICS_INDEX, GRAPHICS_FUNCTION, 0x18);
		dptr = SCREEN (row, 12, col);
		x = *dptr;
		*dptr = 0x7F;
		outpw (GRAPHICS_INDEX, GRAPHICS_FUNCTION, 0);
		break;
	}

	return 0;
}

DISPLAY_INFO ega_init (iapl) int iapl;
{
	DISPLAY_INFO display_info;

	if (iapl) ega_clear_graphics ();
	else text_init (0);

	display_info.routine = ega_display;
	display_info.rows = 25;
	display_info.cols = 80;

	return display_info;
}
