#ifndef DISP_H

#define DISP_H 1

#define DISPLAY_COPY_LINE 1
#define DISPLAY_CLEAR_LINE 2
#define DISPLAY_SCROLL 3
#define DISPLAY_CHAR 4
#define DISPLAY_XCURSOR 5

typedef int (*DISPLAY_ROUTINE) (int, int, int, int);

typedef struct
{
	DISPLAY_ROUTINE routine;
	int rows, cols;
} DISPLAY_INFO;

typedef struct
{
	int row, col, rows, cols;
} DISPLAY_PARAMS;

DISPLAY_INFO text_init (int);

void display_init (char, int);
void display_clear ();
void display_putch (int);
void display_xcursor ();

void display_get_params (DISPLAY_PARAMS *);
void display_move (int, int);
void display_put_char (int, int, byte);
byte display_get_char (int, int);

void display_set_window (int, int, int, int);
void display_reset_window ();

#endif
