#include <dos.h>

#include <iapl.h>

#include <htext.h>
#include <ctext.h>
#include <etext.h>
#include <egafont.h>

#include <disp.h>

#define CR '\r'
#define LF '\n'
#define BS '\b'

#define VDU_GET_MODE 0xF
#define VDU_SET_MODE 0
#define VDU_GET_CURSOR 3
#define VDU_SET_CURSOR_SIZE 1
#define VDU_SET_CURSOR_LOC 2
#define VDU_GET_CHARACTER 8
#define VDU_PUT_CHARACTER 0xA
#define VDU_DISPLAY_CHARACTER 0xE

byte text_table [128] = 
{
	19,	5,		4,		252,	11,	14,	239,	29,
	28,	21,	22,	227,	228,	3,		18,	172,
	159,	170,	171,	240,	2,		155,	156,	169,
	169,	169,	169,	169,	169,	169,	169,	169,

	224,	25,	6,		26,	24,	250,	229,	94,
	234,	249,	237,	15,	232,	236,	31,	30,
	246,	238,	242,	226,	248,	243,	146,	134,
	253,	149,	152,	151,	251,	166,	143,	141,

	241,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	230,	245,	231,	244,	254,

	145,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	235,	167,	233,	158,	23
};

byte display_page [32] [128];
int display_page_base;
int display_mode;
char display_code;

DISPLAY_ROUTINE display_routine;

int display_fullscreen_rows;
int display_fullscreen_cols;
int display_fullscreen;

int display_window_row;
int display_window_col;
int display_window_rows;
int display_window_cols;

int display_row;
int display_col;

int display_soft_scroll;

void text_set_cursor (row, col) int row, col;
{
	union REGS regs;

	regs.h.ah = VDU_SET_CURSOR_LOC;
	regs.h.bh = 0;
	regs.h.dh = (unsigned char) row;
	regs.h.dl = (unsigned char) col;
	int86 (0x10, &regs, &regs);
}

void text_hide_cursor ()
{
	text_set_cursor (25, 0);
}

int text_display (code, row, col, n) int code, row, col, n;
{
	static int cursor_state = 0;
	union REGS regs;

	switch (code)
	{
	case DISPLAY_COPY_LINE:
		while (n--)
		{
			text_set_cursor (row + 1, col);
			regs.h.ah = VDU_GET_CHARACTER;
			regs.h.bh = 0;
			int86 (0x10, &regs, &regs);
			text_set_cursor (row, col);
			regs.h.ah = VDU_PUT_CHARACTER;
			regs.h.bh = 0;
			regs.x.cx = 1;
			int86 (0x10, &regs, &regs);
			col += 1;
		}

		text_hide_cursor ();
		break;

	case DISPLAY_CLEAR_LINE:
		text_set_cursor (row, col);
		regs.h.ah = VDU_PUT_CHARACTER;
		regs.h.al = ' ';
		regs.h.bh = 0;
		regs.x.cx = (unsigned int) n;
		int86 (0x10, &regs, &regs);
		text_hide_cursor ();
		break;

	case DISPLAY_SCROLL:
		text_set_cursor (24, 0);
		regs.h.ah = VDU_DISPLAY_CHARACTER;
		regs.h.al = LF;
		regs.h.bh = 0;
		regs.x.cx = 1;
		int86 (0x10, &regs, &regs);
		text_hide_cursor ();
		break;

	case DISPLAY_CHAR:
		if (n >= 128)
			if (display_code == 'Z') n = (int) text_table [n - 128];
			else if (display_code == 'X') n = n == 255 ? 158 : n == 158 ? 159 : n;

		text_set_cursor (row, col);
		regs.h.ah = VDU_PUT_CHARACTER;
		regs.h.al = (unsigned char) n;
		regs.h.bh = 0;
		regs.x.cx = 1;
		int86 (0x10, &regs, &regs);
		text_hide_cursor ();
		break;

	case DISPLAY_XCURSOR:
		if (cursor_state = ~cursor_state) text_set_cursor (row, col);
		else
		{
/*
			regs.h.ah = VDU_GET_CURSOR;
			regs.h.bh = 0;
			int86 (0x10, &regs, &regs);
			display_row = (int) regs.h.dh;
			display_col = (int) regs.h.dl;
*/
			text_hide_cursor ();
		}
		break;
	}

	return 0;
}

DISPLAY_INFO text_init (iapl) int iapl;
{
	union REGS regs;
	DISPLAY_INFO display_info;

	regs.h.ah = (unsigned char) VDU_SET_MODE;
	regs.h.al = (unsigned char) display_mode;
	int86 (0x10, &regs, &regs);

	if (iapl) text_hide_cursor ();
	else text_set_cursor (0, 0);

	display_info.rows = 25;
	display_info.cols = *(int far *) 0x0040004A;
	display_info.routine = text_display;

	return display_info;
}

DISPLAY_INFO egat_init (iapl) int iapl;
{
	DISPLAY_INFO display_info;

	display_info = text_init (iapl);
	if (iapl) ega_set_font ();

	return display_info;
}

void display_init (code, soft_scroll) char code; int soft_scroll;
{
	DISPLAY_INFO display_info;
	union REGS regs;
	int i, j;

	if (code)
	{
/*
		regs.h.ah = (unsigned char) VDU_GET_MODE;
		int86 (0x10, &regs, &regs);
		display_mode = (int) regs.h.al;
*/
		display_mode = (int) *(char far *) 0x00400049;
		display_code = code;
		display_soft_scroll = soft_scroll;
	}

	display_info =
		(*(display_code == 'H' ? hercules_init :
		display_code == 'C' ? cga_init :
		display_code == 'M' ? mga_init :
		display_code == 'N' ? ega_init :
		display_code == 'X' ? egat_init :
		text_init)) (1);

	display_routine = display_info.routine;

	display_fullscreen_rows = display_info.rows;
	display_fullscreen_cols = display_info.cols;
	display_fullscreen = 1;

	display_window_rows = display_fullscreen_rows;
	display_window_cols = display_fullscreen_cols;
	display_window_row = 0;
	display_window_col = 0;

	display_row = 0;
	display_col = 0;

	for (i = 0; i < display_fullscreen_rows; i++)
		for (j = 0; j < display_fullscreen_cols; j++)
			display_page [i] [j] = ' ';

	display_page_base = 0;
}

void display_clear ()
{
	(*(display_code == 'H' ? hercules_init :
		display_code == 'C' ? cga_init :
		display_code == 'M' ? mga_init :
		display_code == 'N' ? ega_init :
		display_code == 'X' ? egat_init :
		text_init)) (0);
}

void display_scroll ()
{
	byte *sptr, *dptr;
	int row, n;
	register int line, col;
	int cols;

	if (display_fullscreen)
		for (col = display_fullscreen_cols; col--; )
			display_page [(display_page_base + display_fullscreen_rows) & 31]
				[col] = ' ';

	if (display_soft_scroll || !display_fullscreen)
	{
		for (row = 0; row < display_window_rows - 1; row++)
		{
			dptr = display_page [(display_page_base + display_window_row + row) &
				31] + display_window_col + display_window_cols;
			sptr = display_page [(display_page_base + display_window_row + row +
				1) & 31] + display_window_col + display_window_cols;

			for (cols = display_window_cols; cols; cols--)
			{
				sptr -= 1;
				dptr -= 1;
				if (*dptr != ' ' || *sptr != ' ') break;
			}

			(*display_routine) (DISPLAY_COPY_LINE, display_window_row + row,
				display_window_col, cols);

			if (!display_fullscreen) while (cols--) *dptr-- = *sptr--;
		}

		(*display_routine)
			(DISPLAY_CLEAR_LINE, display_window_row + display_window_rows - 1,
				display_window_col, display_window_cols);

		if (!display_fullscreen)
			for (col = display_window_cols; col--; )
				display_page [(display_page_base + display_window_row +
					display_window_rows - 1) & 31] [display_window_col + col] = ' ';
	}
	else (*display_routine) (DISPLAY_SCROLL, 0, 0, 0);

	if (display_fullscreen) display_page_base += 1;
}

void display_putch (c) int c;
{
	register int line;
	byte x;
	int i;
	byte apl = (byte) (c >> 8);
	byte ascii = (byte) c;

	if (!apl) apl = ascii;

	switch (apl)
	{
	case BS:
		if (display_col > display_window_col) display_col -= 1;
		else if (display_row > display_window_row)
		{
			display_row -= 1;
			display_col = display_window_col + display_window_cols - 1;
		}
		break;

	default:
		display_page [(display_page_base + display_row) & 31] [display_col] =
			apl;

		(*display_routine) (DISPLAY_CHAR, display_row, display_col,
			(int) (display_code == 'A' ? ascii : apl));

		display_col += 1;
		if (display_col < display_window_col + display_window_cols) break;

	case CR:
		display_col = display_window_col;
		if (display_row == display_window_row + display_window_rows - 1)
			display_scroll ();
		else display_row += 1;
		break;
	}
}

void display_move (row, col) int row, col;
{
	if (row >= display_window_row && col >= display_window_col &&
		row < display_window_row + display_window_rows &&
		col < display_window_col + display_window_cols)
	{
		display_row = row;
		display_col = col;
	}
}

void display_put_char (row, col, c) int row, col; byte c;
{
	if ((unsigned) row < (unsigned) display_fullscreen_rows &&
		(unsigned) col < (unsigned) display_fullscreen_cols)
	{
		display_page [(display_page_base + row) & 31] [col] = c;
		(*display_routine) (DISPLAY_CHAR, row, col, (int) c);
	}
}

byte display_get_char (row, col) int row, col;
{
	return (unsigned) row < (unsigned) display_fullscreen_rows &&
		(unsigned) col < (unsigned) display_fullscreen_cols ?
			display_page [(display_page_base + row) & 31] [col] : ' ';
}

void display_xcursor ()
{
	(*display_routine) (DISPLAY_XCURSOR, display_row, display_col, 0);
}

void display_get_params (ptr) DISPLAY_PARAMS *ptr;
{
	ptr->rows = display_window_rows;
	ptr->cols = display_window_cols;
	ptr->row = display_row;
	ptr->col = display_col;
}

void display_set_window (row, col, rows, cols) int row, col, rows, cols;
{
	if ((unsigned) row < (unsigned) display_fullscreen_rows &&
			(unsigned) col < (unsigned) display_fullscreen_cols &&
		rows > 0 && row + rows <= display_fullscreen_rows &&
		cols > 0 && col + cols <= display_fullscreen_cols)
	{
		display_window_row = row;
		display_window_col = col;
		display_window_rows = rows;
		display_window_cols = cols;
		display_fullscreen = !row && !col && rows == display_fullscreen_rows &&
			cols == display_fullscreen_cols;
		display_move (display_window_row, display_window_col);
	}
}

void display_reset_window ()
{
	display_window_row = 0;
	display_window_col = 0;
	display_window_rows = display_fullscreen_rows;
	display_window_cols = display_fullscreen_cols;
	display_fullscreen = 1;
}
