#include <dos.h>

#include <iapl.h>
#include <font.h>
#include <disp.h>
#include <graphics.h>

#include <ctext.h>

#define CRTC_INDEX 0x3D4
#define COLOUR_MASK 0xFFFF

int cga_addr_offset;
int cga_offset_table [25] [8];

int cga_mode;
int cga_cols;

int cga_spread [256] = 
{
	0x0000, 0x0300, 0x0C00, 0x0F00, 0x3000, 0x3300, 0x3C00, 0x3F00,
	0xC000, 0xC300, 0xCC00, 0xCF00, 0xF000, 0xF300, 0xFC00, 0xFF00,
	0x0003, 0x0303, 0x0C03, 0x0F03, 0x3003, 0x3303, 0x3C03, 0x3F03,
	0xC003, 0xC303, 0xCC03, 0xCF03, 0xF003, 0xF303, 0xFC03, 0xFF03,
	0x000C, 0x030C, 0x0C0C, 0x0F0C, 0x300C, 0x330C, 0x3C0C, 0x3F0C,
	0xC00C, 0xC30C, 0xCC0C, 0xCF0C, 0xF00C, 0xF30C, 0xFC0C, 0xFF0C,
	0x000F, 0x030F, 0x0C0F, 0x0F0F, 0x300F, 0x330F, 0x3C0F, 0x3F0F,
	0xC00F, 0xC30F, 0xCC0F, 0xCF0F, 0xF00F, 0xF30F, 0xFC0F, 0xFF0F,
	0x0030, 0x0330, 0x0C30, 0x0F30, 0x3030, 0x3330, 0x3C30, 0x3F30,
	0xC030, 0xC330, 0xCC30, 0xCF30, 0xF030, 0xF330, 0xFC30, 0xFF30,
	0x0033, 0x0333, 0x0C33, 0x0F33, 0x3033, 0x3333, 0x3C33, 0x3F33,
	0xC033, 0xC333, 0xCC33, 0xCF33, 0xF033, 0xF333, 0xFC33, 0xFF33,
	0x003C, 0x033C, 0x0C3C, 0x0F3C, 0x303C, 0x333C, 0x3C3C, 0x3F3C,
	0xC03C, 0xC33C, 0xCC3C, 0xCF3C, 0xF03C, 0xF33C, 0xFC3C, 0xFF3C,
	0x003F, 0x033F, 0x0C3F, 0x0F3F, 0x303F, 0x333F, 0x3C3F, 0x3F3F,
	0xC03F, 0xC33F, 0xCC3F, 0xCF3F, 0xF03F, 0xF33F, 0xFC3F, 0xFF3F,
	0x00C0, 0x03C0, 0x0CC0, 0x0FC0, 0x30C0, 0x33C0, 0x3CC0, 0x3FC0,
	0xC0C0, 0xC3C0, 0xCCC0, 0xCFC0, 0xF0C0, 0xF3C0, 0xFCC0, 0xFFC0,
	0x00C3, 0x03C3, 0x0CC3, 0x0FC3, 0x30C3, 0x33C3, 0x3CC3, 0x3FC3,
	0xC0C3, 0xC3C3, 0xCCC3, 0xCFC3, 0xF0C3, 0xF3C3, 0xFCC3, 0xFFC3,
	0x00CC, 0x03CC, 0x0CCC, 0x0FCC, 0x30CC, 0x33CC, 0x3CCC, 0x3FCC,
	0xC0CC, 0xC3CC, 0xCCCC, 0xCFCC, 0xF0CC, 0xF3CC, 0xFCCC, 0xFFCC,
	0x00CF, 0x03CF, 0x0CCF, 0x0FCF, 0x30CF, 0x33CF, 0x3CCF, 0x3FCF,
	0xC0CF, 0xC3CF, 0xCCCF, 0xCFCF, 0xF0CF, 0xF3CF, 0xFCCF, 0xFFCF,
	0x00F0, 0x03F0, 0x0CF0, 0x0FF0, 0x30F0, 0x33F0, 0x3CF0, 0x3FF0,
	0xC0F0, 0xC3F0, 0xCCF0, 0xCFF0, 0xF0F0, 0xF3F0, 0xFCF0, 0xFFF0,
	0x00F3, 0x03F3, 0x0CF3, 0x0FF3, 0x30F3, 0x33F3, 0x3CF3, 0x3FF3,
	0xC0F3, 0xC3F3, 0xCCF3, 0xCFF3, 0xF0F3, 0xF3F3, 0xFCF3, 0xFFF3,
	0x00FC, 0x03FC, 0x0CFC, 0x0FFC, 0x30FC, 0x33FC, 0x3CFC, 0x3FFC,
	0xC0FC, 0xC3FC, 0xCCFC, 0xCFFC, 0xF0FC, 0xF3FC, 0xFCFC, 0xFFFC,
	0x00FF, 0x03FF, 0x0CFF, 0x0FFF, 0x30FF, 0x33FF, 0x3CFF, 0x3FFF,
	0xC0FF, 0xC3FF, 0xCCFF, 0xCFFF, 0xF0FF, 0xF3FF, 0xFCFF, 0xFFFF
};

void cga_clear_graphics (mode) int mode;
{
	union REGS regs;
	register int row, line;

	cga_mode = mode;
	cga_cols = cga_mode == 6 ? 80 : 40;

	regs.x.ax = (unsigned int) cga_mode;
	int86 (0x10, &regs, &regs);

	if (cga_mode == 4)
	{
		regs.x.ax = 0x0B00;
		regs.x.bx = 0x0100;
		int86 (0x10, &regs, &regs);
	}

	for (row = 0; row < 25; row++)
		for (line = 0; line < 8; line++)
			cga_offset_table [row] [line] = 80 * (4 * row + (line >> 1));

	cga_addr_offset = 0;
}

#define SCREEN(ROW,LINE,COL)																	\
	((byte far *) (0xB8000000 +																\
		((cga_addr_offset + cga_offset_table [ROW] [LINE] + (COL)) & 0x1FFF) +	\
		(((LINE) & 1) << 13)))

int cga_display (code, row, col, n) int code, row, col, n;
{
	static int crtc_offset = 0;
	byte far *sptr, far *dptr;
	register int line, j;
	byte x;
	int i;

	switch (code)
	{
	case DISPLAY_COPY_LINE:
		if (cga_mode == 4)
		{
			col <<= 1;
			n <<= 1;
		}

		dptr = SCREEN (row, 0, col);
		sptr = SCREEN (row + 1, 0, col);

		if (((unsigned int) sptr + 320 & 0x2000) ||
			((unsigned int) dptr + 320 & 0x2000))
		{
			for (line = 8; line--;)
				for (j = col; j < col + n; j++)
				{
					x = *SCREEN (row + 1, line, j);
					*SCREEN (row, line, j) = x;
				}
		}
		else
		{
			for (i = 2; i--; )
			{
				for (line = 4; line--; )
				{
					for (j = n; j--; ) *dptr++ = *sptr++;
					sptr += 80 - n;
					dptr += 80 - n;
				}

				sptr += 0x2000 - 320;
				dptr += 0x2000 - 320;
			}
		}

		break;

	case DISPLAY_CLEAR_LINE:
		if (cga_mode == 4)
		{
			col <<= 1;
			n <<= 1;
		}

		for (line = 8; line--; )
			for (j = col, i = n; i--; j++)
				*SCREEN (row, line, j) = 0;

		break;

	case DISPLAY_SCROLL:
		cga_addr_offset += 320;
		cga_display (DISPLAY_CLEAR_LINE, 24, 0, cga_cols);
		crtc_offset += 160;
		outpw (CRTC_INDEX, 12, crtc_offset >> 8);
		outpw (CRTC_INDEX, 13, crtc_offset & 0xFF);
		break;

	case DISPLAY_CHAR:
		for (line = 7; line--; )
		{
			x = cga_font [n] [line];
			if (cga_mode == 6) *SCREEN (row, line, col) = x;
			else
			{
				i = cga_spread [x] & COLOUR_MASK;
				*(int far *) SCREEN (row, line, col << 1) = i;
			}
		}

		if (cga_mode == 6) *SCREEN (row, 7, col) = 0;
		else *(int far *) SCREEN (row, 7, col << 1) = 0;

		break;

	case DISPLAY_XCURSOR:
		if (cga_mode == 6) *SCREEN (row, 7, col) ^= 0x7F;
		else *(int far *) SCREEN (row, 7, col << 1) ^= 0xFF3F & COLOUR_MASK;
		break;
	}

	return 0;
}

DISPLAY_INFO cga_init (iapl) int iapl;
{
	DISPLAY_INFO display_info;

	if (iapl) cga_clear_graphics (6);
	else text_init (0);

	display_info.routine = cga_display;
	display_info.rows = 25;
	display_info.cols = 80;

	return display_info;
}

DISPLAY_INFO mga_init (iapl) int iapl;
{
	DISPLAY_INFO display_info;

	if (iapl) cga_clear_graphics (4);
	else text_init (0);

	display_info.routine = cga_display;
	display_info.rows = 25;
	display_info.cols = 40;

	return display_info;
}
