code	segment	byte
	assume	cs:code

; #MC routine to put character array on mono screen

; arg1 = 2 element integer vector of screen row, column
; arg2 = character scalar, vector or matrix to be displayed

wput	proc	far

; check arg2 type and rank

	mov	si,[bx+2]	; address of arg2

	mov	ax,[si+2]
	cmp	al,1
	jne	error		; arg2 not character

	cmp	ah,2
	ja	error		; arg2 rank > 2

; get rows and columns in arg2

	mov	cx,1		; rows
	mov	dx,1		; columns
	or	ah,ah
	jz	wput1		; arg2 scalar: rows = columns = 1

	inc	si
	inc	si
	mov	dx,[si+4]	; columns
	dec	ah
	jz	wput1		; arg2 vector: rows = 1

	inc	si
	inc	si
	mov	cx,dx		; rows
	mov	dx,[si+4]	; columns
				; arg2 matrix

; cx = rows
; dx = columns

wput1:	add	si,6		; offset of first char in arg2

; check type, rank and shape of arg1

	mov	bx,[bx]		; address of arg1

	cmp	word ptr [bx+2],102H
	jne	error		; arg1 not integer vector

	cmp	word ptr [bx+4],2
	jne	error		; arg1 not length 2

; check row within screen boundary

	mov	ax,[bx+8]	; row

	or	ax,ax
	js	error		; row -ve

	add	ax,cx		; row + rows
	cmp	ax,25
	ja	error		; > 25

	sub	ax,cx		; restore row

; calculate row offset in screen

	mov	bp,160		; bytes per row
	push	dx
	imul	bp
	pop	dx
	mov	di,ax		; row offset

; check column within screen boundary

	mov	ax,[bx+10]	; column

	or	ax,ax
	js	error		; column -ve

	add	ax,dx		; column + columns
	cmp	ax,80
	ja	error		; > 80

	sub	ax,dx		; restore column

; add column offset to row offset

	add	ax,ax		; column offset
	add	di,ax		; screen offset

; display array on screen

	mov	ax,0B000H
	mov	es,ax		; mono screen segment address
	jcxz	wput5		; rows = 0

wput2:	push	cx		; save rows
	push	di		; save screen offset
	mov	cx,dx		; columns
	jcxz	wput4		; columns = 0

wput3:	lodsb			; get next character
	mov	es:[di],al	; place on screen
	inc	di
	inc	di		; point to next screen address
	loop	wput3		; next column

wput4:	pop	di		; restore screen offset
	pop	cx		; restore rows
	add	di,160		; next screen row
	loop	wput2		; next row

wput5:	mov	ax,1		; ok
	ret

error:	xor	ax,ax		; error
	ret

wput	endp

code	ends
	end
                                                                                                   