	TITLE   iaplloop

;===============================================;
;						;
; segment declarations				;
;						;
;===============================================;

_TEXT	segment	byte public 'CODE'
_TEXT	ends

IAPL	segment	para common 'IAPL'
IAPL	ends

	assume  cs:_TEXT
	assume	ds:IAPL,ss:IAPL,es:IAPL

;===============================================;
;						;
; external C functions				;
;						;
;===============================================;

	EXTRN	_aplgetch:near
	EXTRN	_aplputch:near
	EXTRN	_aplprint:near
	EXTRN	_escape:near

	EXTRN	_ifopenr:near
	EXTRN	_ifopenw:near
	EXTRN	_ifread:near
	EXTRN	_ifwrite:near
	EXTRN	_ifclose:near
	EXTRN	_ifreadr:near
	EXTRN	_iferase:near
	EXTRN	_ifdir:near

;===============================================;
;						;
; iapl segment					;
;						;
;===============================================;

IAPL	segment

	org	100H

	public	xdata
xdata	db	6FEH dup (?)

	public	addr
addr	label	word

	public	rom
rom	label	byte

	org	7800H		; allows 28K for ROM

	public	rstack
rstack	db	100H dup (?)

	public	vstack
vstack	db	100H dup (?)

;===============================================;
;						;
; routine address table				;
; indexed by op code * 2			;
;						;
;===============================================;

ENTRY	macro	A,B,C,D

	public	A,B,C,D
	dw	A,icall,B,icall,C,icall,D,icall

	endm

	public instab
instab	label	word

	ENTRY	LNOP,	LADD,	LBAND,	LBNOT
	ENTRY	LBOR,	LBXOR,	LDEC,	LDECDEC
	ENTRY	LDOUBLE,LDUP,	LEQ,	LEZ
	ENTRY	LFILL,	LGET,	LGT,	LGZ
	ENTRY	LHALF,	LINC,	LINCINC,LLAND
	ENTRY	LLBYTE,	LLD,	LLDB,	LLOR
	ENTRY	LLT,	LLXOR,	LLZ,	LMOVE
	ENTRY	LNE,	LNEG,	LNZ,	LOVER
	ENTRY	LPOP,	LPUT,	LROT,	LSTO
	ENTRY	LSTOB,	LSTON,	LSTONB,	LSTOZ
	ENTRY	LSTOZB,	LSUB,	LSWAB,	LSWAP
	ENTRY	LWADD,	LWSIZE,	LESCAPE,LMCALL
	ENTRY	LEXIT,	LFOPENR,LFOPENW,LFREAD
	ENTRY	LFWRITE,LFCLOSE,LFREADR,LPRINT
	ENTRY	LMSG,	LFERASE,LFDIR,	LMUL
	ENTRY	LDIV,	LDADD,	LNOP,	LNOP
	ENTRY	LJU,	LJT,	LJF,	LJD
	ENTRY	LIPUSH,	LIPOP,	LRETURN,LJLONG
	ENTRY	LPUSH0,	LPUSH1,	LPUSHW,	LPUSHB
	ENTRY	LPUSHIZ,LLDI,	LLDBI,	LSTOI
	ENTRY	LSTOBI,	LPUSHM1,LPUSH2,	LPUSHIN
	ENTRY	LCASE,	LDUPJF,	LLDNEXT,LJPUSH
	ENTRY	LPOPPOP,LSWAPOP,LOVOVER,LEQI
	ENTRY	LLDJ,	LSWOVER,LDUPLD,	LDUPSTI
	ENTRY	LDUPJT,	LDUPEQI,LDUPLBY,LDUPLDB
	ENTRY	LDUPLDN,LDUPDUP,LJU1,	LRET0
	ENTRY	LADDI,	LRET1,	LROTROT,LMOVE5
	ENTRY	LNOP,	LNOP,	LNOP,	LNOP
	ENTRY	LSKIP,	LSKIP,	LSKIP,	LSKIP
	ENTRY	LSKIP,	LSKIP,	LSKIP,	LSKIP
	ENTRY	LSKIPF,	LSKIPF,	LSKIPF,	LSKIPF
	ENTRY	LSKIPF,	LSKIPF,	LSKIPF,	LSKIPF

;===============================================;
;						;
; messages					;
;						;
;===============================================;

	public	msgs
msgs	db	'.UNKNOWN',0
	db	'.SYNTAX',0
	db	'INCORRECT COMMAND',0
	db	'.DEFN',0
	db	'.NONCE',0
	db	'WS FULL',0
	db	'.LIMIT',0
	db	'.VALUE',0
	db	'.DOMAIN',0
	db	'.RANK',0
	db	'.LENGTH',0
	db	'NOT COPIED',0
	db	'NOT SAVED',0
	db	'.DISK',0
	db	'ERROR',0
	db	'INTERRUPT',0
	db	'NOT ERASED',0
	db	'.INDEX',0
	db	'.AXIS',0
	db	'NOT FOUND',0

	db	'THE FREE APL INTERPRETER',0
	db	'VERSION',0
	db	'SUPPLIED BY:',0
	db	'I-APL LTD',0
	db	'2 BLENHEIM ROAD',0
	db	'ST ALBANS, HERTS, ENGLAND',0
	db	'79',0
	db	'CLEAR WS',0
	db	'PC',0
	db	'808X',0
	db	'MSDOS',0
	db	'TEXT',0
	db	'PGHCA',0
	db	0

;===============================================;
;						;
; skip instruction offsets			;
;						;
;===============================================;

	public	skiptab
skiptab	dd	1,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8

;===============================================;
;						;
; ws						;
;						;
;===============================================;

	org	8000H

	public	ws
ws	db	32766 dup (?)

IAPL	ends

;===============================================;
;						;
; code segment					;
;						;
;===============================================;

_TEXT	segment

dataseg	dw	?		; C data segment
spsave	dw	?		; initial sp
subaddr	dd	?		; addr of MCALL routine

;===============================================;
;						;
; call c file function				;
;						;
; on entry:	di = proc address		;
;						;
; on exit:	ax = ?				;
;		dx = ?				;
;		di = ?				;
;						;
;===============================================;

pcallf	proc	near

	pop	dx		; return address
	push	bx		; top of vstack
	mov	ax,sp		; vstack pointer

	dec	sp
	dec	sp		; space for result

	push	dx		; return address
	push	cx		; save

	mov	dx,dataseg
	mov	ds,dx
	mov	ss,dx
	xchg	sp,spsave

	mov	dx,seg IAPL
	push	dx
	mov	dx,0
	push	dx		; IAPL address space

	mov	dx,seg IAPL
	push	dx
	push	ax		; vstack pointer

	call	di		; call C file function
	add	sp,8		; ax = vstack pointer offset

	mov	dx,seg IAPL
	mov	es,dx		; IAPL segment
	mov	ds,dx		; IAPL segment
	mov	ss,dx		; IAPL segment
	xchg	sp,spsave	; stack pointer

	pop	cx		; restore
	pop	di		; return address

	xchg	sp,ax		; set vstack pointer to result of
				; C function
	pop	bx		; top of value stack
	jmp	di		; return

pcallf	endp

CALLF	macro	NAME

	mov	di,offset NAME
	call	pcallf

	endm

;===============================================;
;						;
; call c function				;
;						;
; on entry:	ax = arg (if any)		;
;		di = proc address		;
;						;
; on exit:	ax = result (if any)		;
;		dx = ?				;
;						;
;===============================================;

pcallc	proc	near

	push	bx		; save
	push	cx		; save

	mov	dx,dataseg
	mov	ds,dx		; C data segment
	mov	ss,dx		; C data segment
	xchg	sp,spsave	; C stack pointer

	push	ax		; argument
	call	di		; call C function
	inc	sp
	inc	sp		; remove argument

	mov	dx,seg IAPL
	mov	es,dx		; IAPL segment
	mov	ds,dx		; IAPL segment
	mov	ss,dx		; IAPL segment
	xchg	sp,spsave	; vstack pointer

	pop	cx		; restore
	pop	bx		; restore

	ret

pcallc	endp

CALLC	macro	NAME

	mov	di,offset NAME
	call	pcallc

	endm

;===============================================;
;						;
; inner interpreter main loop			;
; on entry:	[sp+2] = logical start addr	;
;						;
;===============================================;

	public	_iaplloop
_iaplloop	proc	near

; save regs

	push	bp
	push	si
	push	di
	mov	ax,ds
	mov	dataseg,ax
	mov	spsave,sp

; set up registers

	mov	ax,seg iapl
	mov	ds,ax
	mov	es,ax

	mov	ss,ax
	mov	sp,offset vstack+100H
				; initial vstack pointer

	mov	bp,offset rstack+100H
				; initial rstack pointer

	mov	si,addr		; initial instruction pointer

	mov	cx,1		; cx = 1 at beginning of all instructions

	jmp	short LNOP	; execute first instruction

; register usage:
; si = instruction pointer
; sp = vstack pointer
; bx = top of vstack
; bp = rstack pointer
; ax, cx, dx, di = working registers
; cx = 1 at beginning of all instructions

; CALL instruction

icall:	dec	si
	lodsw			; ax = call instruction
	dec	bp
	dec	bp
	mov	[bp],si		; push return address on rstack
	shr	ax,1
	xchg	si,ax		; si = routine address

; fall through to LNOP

;===============================================;
;						;
; macro to get next instruction and choose	;
; routine					;
;						;
;===============================================;

NEXT	macro

	lodsb
	mov	ah,ch		; ax = op code
	add	ax,ax
	xchg	di,ax
	jmp	instab[di]	; jump to routine

	endm

;===============================================;
;						;
; instructions					;
;						;
;===============================================;

LNOP:	NEXT

LADD:	pop	ax
	add	bx,ax
	NEXT

LBAND:	pop	ax
	and	bx,ax
	NEXT

LBNOT:	not	bx
	NEXT

LBOR:	pop	ax
	or	bx,ax
	NEXT

LBXOR:	pop	ax
	xor	bx,ax
	NEXT

LDADD:	mov	cx,bx		; cx = count
	pop	di		; di = dest
	pop	bx		; bx = source
	add	bx,cx		; point to end
	add	di,cx		; point to end
	xor	dx,dx		; dl = carry, dh = 0
	jcxz	ldadd3
ldadd1:	dec	bx
	dec	di
	xchg	al,dl		; al = carry
	add	al,[bx]		; al += source
	add	al,[di]		; al += dest
	mov	dl,dh		; carry = 0
	cmp	al,10
	jl	ldadd2		; no carry
	sub	al,10		; adjust for carry
	inc	dl		; carry = 1
ldadd2:	mov	[di],al		; store result
	loop	ldadd1
ldadd3:	mov	bx,dx		; carry
	inc	cx		; cx = 1
	NEXT

LDECDEC:dec	bx
LDEC:	dec	bx
	NEXT

LDOUBLE:add	bx,bx
	NEXT

LDUPDUP:push	bx
LDUP:	push	bx
	NEXT

LEQ:	pop	ax
	cmp	ax,bx
	mov	bx,cx
	je	leq1
	dec	bx
leq1:	NEXT

LEZ:	or	bx,bx
	mov	bx,cx
	jz	lez1
	dec	bx
lez1:	NEXT

LFILL:	mov	cx,bx		; count
	pop	di		; dest
	pop	ax		; al = fill byte
	pop	bx
	jcxz	lfill1
	rep	stosb		; fill
lfill1:	inc	cx		; cx = 1
	NEXT

LGET:	push	bx
	CALLC	_aplgetch	; get ax
	xchg	bx,ax
	NEXT

LGT:	pop	ax
	cmp	ax,bx
	mov	bx,cx
	jg	lgt1
	dec	bx
lgt1:	NEXT

LGZ:	or	bx,bx
	mov	bx,cx
	jg	lgz1
	dec	bx
lgz1:	NEXT

LHALF:	sar	bx,1
	NEXT

LINCINC:inc	bx
LINC:	inc	bx
	NEXT

LLAND:	pop	ax
	or	bx,bx
	jz	lland1
	xchg	bx,ax
	or	bx,bx
	jz	lland1
	mov	bx,cx
lland1:	NEXT

LDUPLBY:push	bx
LLBYTE:	or	bh,bh
	mov	bx,cx
	jz	llbyte1
	dec	bx
llbyte1:NEXT

LDUPLD:	push	bx
LLD:	mov	bx,[bx]
	NEXT

LDUPLDB:push	bx
LLDB:	mov	bl,[bx]
	mov	bh,ch
	NEXT

LLOR:	pop	ax
	or	bx,ax
	jz	llor1
	mov	bx,cx
llor1:	NEXT

LLT:	pop	ax
	cmp	ax,bx
	mov	bx,cx
	jl	llt1
	dec	bx
llt1:	NEXT

LLXOR:	pop	ax
	or	bx,bx
	jz	llxor1
	mov	bx,cx
llxor1:	or	ax,ax
	jz	llxor2
	xor	bx,cx
llxor2:	NEXT

LLZ:	or	bx,bx
	mov	bx,cx
	jl	llz1
	dec	bx
llz1:	NEXT

LMOVE:	mov	cx,bx		; count
	pop	di		; di = dest
	pop	bx		; bx = source
	jcxz	lmove1
	cmp	bx,di
	jb	lmove2		; move up
	xchg	si,bx
	rep	movsb		; move down
	xchg	si,bx
lmove1:	pop	bx
	inc	cx		; cx = 1
	NEXT
lmove2:	add	bx,cx
	add	di,cx
	dec	bx		; point to end
	dec	di		; point to end
	xchg	si,bx
	std
	rep	movsb		; move down
	cld
	xchg	si,bx
	pop	bx
	inc	cx		; cx = 1
	NEXT

LNE:	pop	ax
	sub	bx,ax
	jz	lne1
	mov	bx,cx
lne1:	NEXT

LNEG:	neg	bx
	NEXT

LNZ:	or	bx,bx
	jz	lnz1
	mov	bx,cx
lnz1:	NEXT

LOVER:	mov	di,sp
	push	bx
	mov	bx,[di]
	NEXT

LPOPPOP:pop	bx
LPOP:	pop	bx
	NEXT

LPUT:	xchg	ax,bx
	pop	bx
	CALLC	_aplputch	; put ax
	NEXT

LROT:	pop	ax
	mov	di,sp
	xchg	ax,[di]
	push	bx
	xchg	ax,bx
	NEXT

LSTO:	pop	ax
	mov	[bx],ax
	pop	bx
	NEXT

LSTOB:	pop	ax
	mov	[bx],al
	pop	bx
	NEXT

LSTON:	mov	[bx],cx
	pop	bx
	NEXT

LSTONB:	mov	[bx],cl
	pop	bx
	NEXT

LSTOZ:	mov	word ptr [bx],0
	pop	bx
	NEXT

LSTOZB:	mov	[bx],ch
	pop	bx
	NEXT

LSUB:	pop	ax
	sub	ax,bx
	xchg	bx,ax
	NEXT

LSWAB:	xchg	bh,bl
	NEXT

LSWAP:	mov	di,sp
	xchg	bx,[di]
	NEXT

LWADD:	add	bh,80H
	NEXT

LWSIZE:	push	bx
	mov	bx,32766
	NEXT

LESCAPE:push	bx
	push	si
	push	bp
	push	es
	mov	ah,0Bh
	int	21h		; char waiting ?
	pop	es
	pop	bp
	pop	si
	mov	cx,1
	mov	ah,ch
	or	al,al
	jz	lescape1
	CALLC	_escape		; ax = escape
lescape1:
	xchg	bx,ax
	NEXT

LMCALL:	mov	word ptr subaddr,bx
	mov	word ptr subaddr+2,ds
				; subaddr = routine address
	mov	di,bx		; di = offset of routine
	pop	cx		; count
	pop	bx		; bx = address table address
	push	bp		; save
	push	si		; save
	push	ds		; save
	push	es		; save
	call	subaddr		; call routine
	pop	es		; restore
	pop	ds		; restore
	pop	si		; restore
	pop	bp		; restore
	mov	bx,ax		; 1 for ok
	mov	cx,1
	NEXT

LEXIT:	mov	ax,dataseg
	mov	ds,ax
	mov	ss,ax
	mov	sp,spsave
	pop	di
	pop	si
	pop	bp
	ret

LFOPENR:CALLF	_ifopenr
	NEXT

LFOPENW:CALLF	_ifopenw
	NEXT

LFREAD:	CALLF	_ifread
	NEXT

LFWRITE:CALLF	_ifwrite
	NEXT

LFCLOSE:CALLF	_ifclose
	NEXT

LFREADR:CALLF	_ifreadr
	NEXT

LFERASE:CALLF	_iferase
	NEXT

LFDIR:	CALLF	_ifdir
	NEXT

LPRINT:	xchg	ax,bx
	pop	bx
	CALLC	_aplprint	; print ax
	NEXT

LMSG:	pop	dx		; msg number
	mov	di,offset msgs
	mov	al,ch		; al = 0
	mov	cx,-1		; for forthcoming scasb, movsb
lmsg1:	or	dx,dx
	jz	lmsg3		; msg found
	cmp	byte ptr [di],0
	je	lmsg2		; end of msg table
	repnz	scasb		; skip this msg
	dec	dx		; decrement msg number
	jmp	lmsg1
lmsg2:	xor	dx,dx
lmsg3:	cmp	byte ptr [di],dl
	je	lmsg4		; msg length = 0
	mov	dx,di		; msg start
	repnz	scasb		; search for end of msg
	sub	di,dx
	dec	di		; msg length
	xchg	bx,dx		; bx = msg start
	xchg	di,dx		; di = dest
	mov	cx,dx		; cx = dx = msg length
	xchg	si,bx
	rep	movsb
	xchg	si,bx
lmsg4:	mov	bx,dx		; msg length
	mov	cx,1
	NEXT

LMUL:	pop	ax
	imul	bx
	push	ax		; bottom word
	mov	bx,dx		; top word
	NEXT

LDIV:	pop	ax
	cwd			; dx, ax = dividend
	idiv	bx
	or	dx,dx
	jz	ldiv1		; remainder = 0
	xor	bx,dx
	jns	ldiv1		; signs of divisor and remainder
				;the same
	xor	bx,dx
	add	dx,bx		; signs different: adjust remainder
	dec	ax		; and quotient
ldiv1:	push	ax		; quotient
	mov	bx,dx		; remainder
	NEXT

LJU1:	push	bx
	mov	bx,cx
LJU:	lodsb
	mov	ah,ch
	add	si,ax
	NEXT

LJT:	or	bx,bx
	pop	bx
	jz	ljt1
	lodsb
	mov	ah,ch
	add	si,ax
	NEXT
ljt1:	inc	si
	NEXT

LJF:	or	bx,bx
	pop	bx
	jnz	ljf1
	lodsb
	mov	ah,ch
	add	si,ax
	NEXT
ljf1:	inc	si
	NEXT

LJD:	cmp	word ptr [bp],0
	jne	ljd1
	inc	si
LIPOP:	inc	bp
	inc	bp
	NEXT
ljd1:	dec	word ptr [bp]
	lodsb
	mov	ah,-1
	add	si,ax
	NEXT

LIPUSH:	dec	bp
	dec	bp
	mov	[bp],bx
	pop	bx
	NEXT

LRET0:	push	bx
	xor	bx,bx
LRETURN:mov	si,[bp]
	inc	bp
	inc	bp
	NEXT

LJLONG:	lodsw
	add	si,ax
	NEXT

LPUSH0:	push	bx
	xor	bx,bx
	NEXT

LPUSH1:	push	bx
	mov	bx,cx
	NEXT

LPUSHW:	push	bx
	lodsw
	xchg	bx,ax
	NEXT

LPUSHB:	push	bx
	lodsb
	mov	ah,ch
	xchg	bx,ax
	NEXT

LPUSHIZ:push	bx
	lodsb
	mov	ah,cl
	xchg	bx,ax
	NEXT

LLDI:	push	bx
	lodsb
	mov	ah,cl
	xchg	bx,ax
	mov	bx,[bx]
	NEXT

LLDBI:	push	bx
	lodsb
	mov	ah,cl
	xchg	bx,ax
	mov	bl,[bx]
	dec	bh
	NEXT

LSTOI:	lodsb
	mov	ah,cl
	xchg	di,ax
	mov	[di],bx
	pop	bx
	NEXT

LSTOBI:	lodsb
	mov	ah,cl
	xchg	di,ax
	mov	[di],bl
	pop	bx
	NEXT

LPUSHM1:push	bx
	mov	bx,-1
	NEXT

LPUSH2:	push	bx
	mov	bx,2
	NEXT

LPUSHIN:push	bx
	lodsb
	mov	ah,2
	xchg	bx,ax
	NEXT

LCASE:	lodsb
	mov	ah,ch		; ax = call table size
	add	ax,si		; return address
	dec	bp
	dec	bp
	mov	[bp],ax		; push return address on rstack
	add	bx,bx
	add	si,bx
	pop	bx
	mov	si,[si]		; call instruction
	shr	si,1		; routine address
	NEXT

LDUPJF:	or	bx,bx
	jnz	ldupjf1
	lodsb
	mov	ah,ch
	add	si,ax
	NEXT
ldupjf1:inc	si
	NEXT

LDUPLDN:push	bx
LLDNEXT:mov	bx,[bx+2]
	NEXT

LSWAPOP:pop	ax
	NEXT

LOVOVER:mov	di,sp
	push	bx
	push	[di]
	NEXT

LJPUSH:	dec	bp
	dec	bp
	mov	[bp],bx
	pop	bx
	lodsb
	mov	ah,ch
	add	si,ax
	NEXT

LDUPEQI:push	bx
LEQI:	lodsb
	mov	ah,ch
	cmp	ax,bx
	mov	bx,cx
	je	leqi1
	dec	bx
leqi1:	NEXT

LLDJ:	push	bx
	lodsb
	mov	ah,2
	xchg	di,ax
	mov	bx,[di]
	NEXT

LSWOVER:pop	ax
	push	bx
	push	ax
	NEXT

LDUPSTI:lodsb
	mov	ah,cl
	xchg	di,ax
	mov	[di],bx
	NEXT

LDUPJT:	or	bx,bx
	jz	ldupjt1
	lodsb
	mov	ah,ch
	add	si,ax
	NEXT
ldupjt1:inc	si
	NEXT

LADDI:	lodsb
	mov	ah,ch
	add	bx,ax
	NEXT

LRET1:	push	bx
	mov	bx,cx
	mov	si,[bp]
	inc	bp
	inc	bp
	NEXT

LROTROT:pop	ax
	mov	di,sp
	xchg	bx,[di]
	push	bx
	xchg	bx,ax
	NEXT

LMOVE5:	mov	di,bx		; di = dest
	pop	bx		; bx = source
	xchg	si,bx
	movsb
	movsb
	movsb
	movsb
	movsb
	xchg	si,bx
	pop	bx
	NEXT

LSKIPF:	or	bx,bx
	pop	bx
	jnz	lskip1
LSKIP:	add	si,word ptr skiptab[di-1C0H]
lskip1:	NEXT

_iaplloop	endp

_TEXT	ends
	end
                                                                                                                                                                                                                                                  