/******************************************************************/
/*																						*/
/*	includes																			*/
/*																						*/
/******************************************************************/

#include <stdio.h>
#include <conio.h>
#include <memory.h>
#include <string.h>
#include <io.h>
#include <dos.h>

/******************************************************************/
/*																						*/
/*	manifest constants															*/
/*																						*/
/******************************************************************/

#define BYTE unsigned char

#define BS 8
#define LF 10
#define CR 13
#define ESC 27

#define SESSION_FILE_NAME "iapl.ses"

/******************************************************************/
/*																						*/
/*	globals																			*/
/*																						*/
/******************************************************************/

void iaplloop ();					/* assembler loop */

int record_session = 0;			/* session recording on */
int ascii_display = 0;			/* ascii display wanted */
int epson = 0;						/* epson printer is being used */

char dos_dta [128];				/* dos data transfer area */

/******************************************************************/
/*																						*/
/*	epson character set download string										*/
/*																						*/
/******************************************************************/

BYTE epson_download [] =
{
	27,64,
	27,58,0,0,0,
	27,37,1,0,

	27,38,0,128,150,
		140, 80,136, 20,130, 81, 34, 20, 40, 80,  0,  0,
		140,192,  0,192,  0,  0,  0,192,  0,192,  0,  0,
		138, 16, 40, 68,130, 68, 40, 16,  0,  0,  0,  0,
		138, 60,  0,  2,  0,  2,  0, 60,  0,  0,  0,  0,
		138, 24,  0, 36,  0, 36,  0, 36,  0,  0,  0,  0,
		155,  0, 36,  0, 36,  0, 36,  0, 24,  0,  0,  0,
		138, 30,  0, 32,  0, 32,  0, 30,  0,  0,  0,  0,
		155,  0,124,  0, 16,  0, 16,  0, 16,  0,  0,  0,
		138, 16,  0, 16,  0, 16,  0,124,  0,  0,  0,  0,
		138, 34,  0, 34, 28, 34,  0, 34,  0,  0,  0,  0,
		140, 16, 32, 92,162, 16,138,116,  8, 16,  0,  0,
		138,152,  0, 36,  0, 36,  0,152,  0,  0,  0,  0,
		140,156,  0, 34,  0, 34,  0, 34,  0,156,  0,  0,
		155,  0, 57, 68, 17, 68, 17, 68,  1,  0,  0,  0,
		 10, 65,  0,121,  4,  1,  4,  9,  0,  0,  0,  0,
		140,136,  0, 10,  4, 56,  4, 10,  0,136,  0,  0,
		140, 72, 16,  0, 16,  8,  4,  0,  4, 72,  0,  0,
		138,160,  0, 32, 30, 32,  0,160,  0,  0,  0,  0,
		140, 80,  8, 20,  2, 17,  2, 20,  8, 80,  0,  0,
		140, 84,  0, 84,  0, 84,  0, 84,  0, 84,  0,  0,
		140, 84,  2, 84,  8, 84, 32, 84,128, 84,  0,  0,
		139, 24, 36,  0, 36,219, 36,  0, 36,  0,  0,  0,
		139,  2, 20,106,144,  2, 64,  2,  4,  0,  0,  0,

	27,38,0,159,192,
		153,  0,254,  0,130,  0,254,  0,  0,  0,  0,  0,
		140, 28,  0, 34,  0, 34,  0, 28,  0, 34,  0,  0,
		138, 16,  8,  4,250,  4,  8, 16,  0,  0,  0,  0,
		140, 16,  0, 56,  0, 84,  0, 16,  0, 16,  0,  0,
		140, 16,  0, 16,  0, 84,  0, 56,  0, 16,  0,  0,
		138, 16, 32, 64,190, 64, 32, 16,  0,  0,  0,  0,
		138, 64, 32, 16,  8, 16, 32, 64,  0,  0,  0,  0,
		140, 80,136,  4,130, 65, 34,  4, 40, 80,  0,  0,
		138,  8, 16, 32, 64, 32, 16,  8,  0,  0,  0,  0,
		140, 65,130,  4,136, 80, 40,  4, 34, 65,  0,  0,
		140, 56,  0, 68,  0, 68,  0, 68,  0, 56,  0,  0,
		140,184, 68, 32, 68, 16, 68,  8, 68, 56,  2,  0,
		140,124,130, 40,146, 96,146, 40,130,124,  0,  0,
		140, 56, 68,  0, 68,186, 68,  0, 68, 56,  0,  0,
		140, 96, 16, 72,  4, 66,  4, 72, 16, 96,  0,  0,
		140, 32, 16, 40,  4,251,  4, 40, 16, 32,  0,  0,
		140,  4,  8, 20, 32,223, 32, 20,  8,  4,  0,  0,
		140, 16,  0, 16, 68, 16, 68, 16,  0, 16,  0,  0,
		140, 56,  0, 84,  0, 84,  0, 84,  0, 68,  0,  0,
		138,138,  0,218,  0,114,  0, 34,  0,  0,  0,  0,
		138, 32,  0, 60,  2,  0,  2,  4,  0,  0,  0,  0,
		138, 24,  0, 36,  0, 36,  0, 24,  0,  0,  0,  0,
		138, 34,  0,114,  0,218,  0,138,  0,  0,  0,  0,
		140, 68,  0, 40,  0, 16,  0, 40,  0, 68,  0,  0,
		138, 42,  4, 40, 16, 40, 64,168,  0,  0,  0,  0,
		155,  0,128,  0,128,  0,128,  0,128,  0,  0,  0,
		140,254,  0,130,  0,130,  0,130,  0,254,  0,  0,
		140,254,  0,146,  0,214,  0,146,  0,254,  0,  0,
		140,254,  0,130,  0,226,  0,130,  0,254,  0,  0,
		 11, 15, 48, 64,136,  0,136, 80, 32,  0,  0,  0,
		138, 62,  0, 72,  0, 72,  0, 62,  0,  0,  0,  0,
		153,  0,254,  0,  2,  0,  2,  0,  0,  0,  0,  0,
		153,  0,254,  0,128,  0,128,  0,  0,  0,  0,  0,
		 12, 13, 16, 37, 64,133, 64, 37, 16, 13,  0,  0,

	27,38,0,219,224,
		138,  2,  0,  2, 60,  2,  0,  2,  0,  0,  0,  0,
		138, 18, 40,  2,108,  2, 40, 18,  0,  0,  0,  0,
		138, 32,  0, 32, 30, 32,  0, 32,  0,  0,  0,  0,
		138, 72, 20, 64, 54, 64, 20, 72,  0,  0,  0,  0,
		183,  0,  0,  0,254,  0,  0,  0,  0,  0,  0,  0,
		140,  6,  8, 18, 32, 66, 32, 18,  8,  6,  0,  0,

	27,38,0,251,255,
		138, 18,  4, 24,  0, 48, 64,144,  0,  0,  0,  0,
		138,144, 64, 48,  0, 24,  4, 18,  0,  0,  0,  0,
		140, 56,  0, 84,  0, 84,  0, 84,  0, 56,  0,  0,
		 27,  0, 32,  0, 44,  1, 46,  0, 32,  0,  0,  0,
		140, 28, 34,  0,  2, 12,  2,  0, 34, 28,  0,  0,

	27,54
};

/******************************************************************/
/*																						*/
/*	initial entry point															*/
/*																						*/
/******************************************************************/

void main (argc, argv) int argc; char *argv [];
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	register FILE *file;
	register int i;

	/* set up dos dta */

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* check flags */

	if (argc > 1)
	{
		if (*argv [1] != '/')
		{
			printf ("\
Argument must be a '/' followed by one or more of the following\n\
  A  display ASCII versions of APL charaters\n\
  S  append all characters typed to file IAPL.SES (debugging aid)\n\
  E  download character set to EPSON at start of session");
			return;
		}

		record_session =
			strchr (argv [1], 'S') || strchr (argv [1], 's');
		ascii_display =
			strchr (argv [1], 'A') || strchr (argv [1], 'a');
		epson = strchr (argv [1], 'E') || strchr (argv [1], 'e');

		if (epson)
			for (i = 0; i < sizeof (epson_download); i++)
				fputc ((int) epson_download [i], stdprn);

		if (record_session)
		{
			file = fopen (SESSION_FILE_NAME,"at");
			if (file)
			{
				fprintf (file, "\f\f\f\f\n");
				fclose (file);
			}
		}
	}

	/* call assembler loop */

	iaplloop ();
}

/******************************************************************/
/*																						*/
/*	record character in session file											*/
/*																						*/
/******************************************************************/

void record_char (c) register int c;
{
	static char record_buffer [80];
	static int record_count = 0;
	register FILE *file;

	if (!record_session) return;

	if (c == CR || record_count == 80)
	{
		file = fopen (SESSION_FILE_NAME,"at");
		if (file)
		{
			fwrite (record_buffer, 1, record_count, file);
			fputc (c == CR ? LF : c, file);
			fclose (file);
		}
		record_count = 0;
	}
	else record_buffer [record_count++] = (char) c;
}

/******************************************************************/
/*																						*/
/*	check for escape																*/
/*																						*/
/******************************************************************/

BYTE kb_buffer [256];
BYTE kb_ptr = 0;
BYTE kb_size = 0;

int escape ()
{
	int c;

	while (kb_size != 255)
	{
		if (!kbhit ()) return 0;
		c = getch ();
		if (c == ESC)
		{
			while (kbhit ()) getch ();
			kb_size = 0;
			return 1;
		}
		kb_buffer [(BYTE) (kb_ptr + kb_size)] = (BYTE) c;
		kb_size += 1;
	}

	return 0;
}

/******************************************************************/
/*																						*/
/*	get character and record if required									*/
/*																						*/
/******************************************************************/

int mygetch ()
{
	register int c = kb_size ?
		(kb_size -= 1, (int) (kb_buffer [kb_ptr++])) : getch ();

	record_char (c);
	return c;
}

/******************************************************************/
/*																						*/
/*	get character and convert to iapl										*/
/*																						*/
/******************************************************************/

#define INS 82
#define DEL 83
#define CUL 75
#define CUR 77
#define HOME 71
#define END 79
#define CCUL 115
#define CCUR 116
#define ALT1 120
#define ALT2 121
#define ALT3 122
#define ALT4 123
#define ALT5 124
#define ALT6 125
#define ALT7 126
#define ALT8 127
#define ALT9 128
#define ALT0 129

int aplgetch ()
{
	static int ascii_input = 0;
	static int xlate [] [2] =
	{
		{DEL, 0x7F},
		{CUL, 1}, {CUR, 2}, {HOME, 3}, {END, 4}, {CCUL, 5}, {CCUR, 6},
		{ALT1, 0x95}, {ALT2, 0xB8}, {ALT3, 0x96}, {ALT4, 0xE0},
		{ALT5, 0xC0},
		{ALT6, 0xFD}, {ALT7, 0xFE},
		{ALT9, 0xA6}, {ALT0, 0xA8}
	};

	register int i;
	register int c = mygetch ();

	if (c) return c == BS || c == CR || c == ESC ? c :
		c < ' ' ? 0 :
		ascii_input ? c | (c << 8) : c;
	else
	{
		c = mygetch ();
		if (c == INS) ascii_input = ~ascii_input;

		for (i = 0; xlate [i] [0] != 0; i++)
			if (c == xlate [i] [0]) return xlate [i] [1];

		return 0;
	}
}

/******************************************************************/
/*																						*/
/*	convert apl char and display												*/
/*																						*/
/******************************************************************/

BYTE disp_table [128] = 
{
	19,	5,		4,		252,	11,	14,	239,	29,
	28,	21,	22,	227,	228,	3,		18,	172,
	159,	170,	171,	240,	2,		155,	156,	169,
	169,	169,	169,	169,	169,	169,	169,	169,

	224,	25,	6,		26,	24,	250,	229,	94,
	234,	249,	237,	15,	232,	236,	31,	30,
	246,	238,	242,	226,	248,	243,	146,	134,
	253,	149,	152,	151,	251,	166,	143,	141,

	241,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	230,	245,	231,	244,	254,

	145,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	235,	167,	233,	158,	23
};

void aplputch (c) register int c;
{
	register a = (c >> 8) & 0xFF;

	if (!a) putch (c);
	else if (a == CR) putch (CR), putch (LF);
	else putch
		(ascii_display ? c : a < 128 ? a : (int) disp_table [a - 128]);
}

/******************************************************************/
/*																						*/
/*	print char																		*/
/*																						*/
/******************************************************************/

void aplprint (c) register int c;
{
	register a = (c >> 8) & 0xFF;

	if (!a) fputc (c, stdprn);
	else if (a == CR) fputc (CR, stdprn), fputc (LF, stdprn);
	else fputc (epson ? a : c, stdprn);
	fflush (stdprn);
}

/******************************************************************/
/*																						*/
/* file primitives																*/
/*																						*/
/******************************************************************/

FILE *file = 0;					/* file handle for iapl file */
int file_size;						/* file size in bytes */
int filled = 0;					/* flag for freadr buffer filled */
char file_name_buffer [13];	/* file name buffer */
char freadr_buffer [32766];	/* freadr buffer */

#define Z vs [2]				/* third item in value stack */
#define Y vs [1]				/* second item in value stack */
#define X vs [0]				/* top item in value stack */
#define W vs [-1]				/* item immediately above value stack */

char *get_file_name (buffer) char far *buffer;
{
	register char *ptr = file_name_buffer;
	register int i;

	for (i = 8; i && *buffer != ' '; i--) *ptr++ = *buffer++;
	*ptr = 0;
	return strcat (file_name_buffer, ".iws");
}

int read_file (dest, size) char far *dest; int size;
{
	char buffer [512];
	register char *ptr;
	register int n;

	if (!file || fseek (file, 2L, 0)) return 0;

	while (size)
	{
		n = size < 512 ? size : 512;
		size -= n;
		if (fread (buffer, 1, n, file) != n) return 0;
		for (ptr = buffer; n; n--) *dest++ = *ptr++;
	}

	return 1;
}

int write_file (source, size) char far *source; int size;
{
	char buffer [512];
	int n;
	register char *ptr;
	register int i;

	if (!file || fseek (file, 0L, 0) ||
		!fwrite ((char *) &size, 2, 1, file)) return 0;

	while (size)
	{
		i = n = size < 512 ? size : 512;
		size -= i;
		for (ptr = buffer; i; i--) *ptr++ = *source++;
		if (fwrite (buffer, 1, n, file) != n) return 0;
	}

	return 1;
}

int far *ifopenr (vs, iapl) int far *vs; char far *iapl;
{
	if (file) fclose (file);
	file = fopen (get_file_name (iapl + X), "rb");
	X = file && fread ((char *) &file_size, 2, 1, file);
	filled = 0;
	return vs;
}

int far *ifopenw (vs, iapl) int far *vs; char far *iapl;
{
	if (file) fclose (file);
	file = fopen (get_file_name (iapl + X), "wb");
	X = file != 0;
	file_size = 0;
	filled = 0;
	return vs;
}

int far *ifread (vs, iapl) int far *vs; char far *iapl;
{
	Y = file_size <= X && read_file (iapl + Y, file_size);
	return vs + 1;
}

int far *ifwrite (vs, iapl) int far *vs; char far *iapl;
{
	Y = write_file (iapl + Y, X);
	if (Y) file_size = X;
	return vs + 1;
}

int far *ifclose (vs, iapl) int far *vs; char far *iapl;
{
	W = file && !fclose (file);
	file = 0;
	return vs - 1;
}

int far *ifreadr (vs, iapl) int far *vs; char far *iapl;
{
	char far *iapl_ptr = iapl + Z;
	register char *fb_ptr = freadr_buffer + Y;
	register int n;

	Z = file &&
		X + Y <= file_size &&
		(filled ||
		(filled = read_file ((char far *) freadr_buffer, file_size)));

	if (Z) for (n = X; n; n--) *iapl_ptr++ = *fb_ptr++;

	return vs + 2;
}

int far *iferase (vs, iapl) int far *vs; char far *iapl;
{
	W = file && !fclose (file) && !unlink (file_name_buffer);
	return vs - 1;
}

int far *ifdir (vs, iapl) int far *vs; char far *iapl;
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	unsigned int dta_seg, dta_offset;
	int found;
	char *ptr;
	char far *iapl_ptr;

	/* get current dta */

	inregs.h.ah = 0x2F;
	intdos (&inregs, &outregs);
	segread (&segregs);
	dta_seg = segregs.es;
	dta_offset = outregs.x.bx;

	/* set dta to dos_dta */

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* directory search */

	inregs.x.dx = (unsigned int) "*.IWS";
	inregs.h.ah = Y ? 0x4F : 0x4E;
	intdosx (&inregs, &outregs, &segregs);

	found = !outregs.x.cflag;	/* file found */

	/* restore original dta */

	segregs.ds = dta_seg;
	inregs.x.dx = dta_offset;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* copy file name to destination */

	Y = 0;

	if (found)
		for (ptr = dos_dta + 30, iapl_ptr = iapl + X; *ptr != '.'; Y++)
			*iapl_ptr++ = *ptr++;

	return vs + 1;
}
size : 512;
		size -= n;
		if (fread (buffer, 1, n, file) != n) return 0;
		for (ptr = buffer; n; n--) *dest++ = *ptr++;
	}

	return 1;
}

int write_file 