;Incomplete DEGO for Apple ][ 
;interpreter for I-APL
;PAGE REFERENCES TO APPLE PROGRAMMER'S HANDBOOK, BY PAUL IRWIN
; LITERAL DEFINITIONS


;WORD REGISTERS
IP	EQU	$00	;in page 0
RS	EQU	$02
TS	EQU	$04
SCRATCH	EQU	$06

;PAGE ALIGNED BYTE POINTERS
;ROM runs from $4000 to $95FF (21.5K) and then $0800 to ??? (under 2K please)
;leaving balance of 6K up to 1FFF for dego. 
ROM1	EQU	$40			;first byte of address $4000
ROM2	EQU	$08			;first byte of address $0800
DATA	EQU	$08
WS	EQU	$0A
MCALL	EQU	$0C

;GRAPHICS CHARACTER ROUTINE STORAGE
ZCHAR	EQU	0E	;BYTE
ROW	EQU	10	;BYTE
COL	EQU	12	;BYTE
SCREEN1	EQU	14	;WORD
SCREEN2	EQU	16	;WORD
CTABLE  EQU	$D000	;WORD POINTER TO 256 x 8=2K  PUT IN BANK SELECT AREA?

;OTHER SCRATCH STORAGE
FILE:	DB	$18

;BUFFERS
BUFFER	EQU	$9AA6		;DATA FIELD OF FILE BUFFER--p. 441
FTSL	EQU	BUFFER+256	;TRACK/SECTOR LIST FIELD OF FILE BUFFER
FSTAT	EQU	TSL+256		;STATUS FIELD OF FILE BUFFER
FNAME	EQU	FSTAT+45	;NAME FIELD OF FILE BUFFER
STATP	EQU	FNAME+30	;POINTS TO STATUS FIELD
TSLP	EQU	STATP+2		;POINTS TO TSL FIELD
DATAP	EQU	TSLP+2		;POINTS TO DATA FIELD
NEXTP	EQU	DATAP+2		;POINTER TO NEXT BUFFER--SET TO $0000

PARAMS	EQU			;PARAMETER LIST FOR FILE MANAGER--12 BYTES
				;PAGE 435
FN	EQU	PARAMS		;ALL---FILE FUNCTION CODE
MODE	EQU	PARAMS+1	;RW----$02=RANGE,$04=POSITION/RANGE
RECORD	EQU	PARAMS+2	;RW----RECORD NUMBER, OR $0000 FOR SEQUENTIAL
RSIZE	EQU	PARAMS+2	;O-----RECORD SIZE, OR $0000 FOR SEQUENTIAL
VOL	EQU	PARAMS+4	;OD----VOLUME NUMBER, OR $00 FOR ANY
DRIVE	EQU	PARAMS+5	;OD----DISK DRIVE NUMBER ($01)
OFFSET	EQU	PARAMS+4	;RWP---BYTE OFFSET (SEQUENTIAL), $0000 (RANDOM)
SLOT	EQU	PARAMS+6	;OD----SLOT NUMBER OF DISK CONTROLLER ($06)
FTYPE	EQU	PARAMS+7	;O-----FILE TYPE (USE 20 FOR A-TYPE)
LENGTH	EQU	PARAMS+6	;RW----NUMBER OF BYTES TO READ OR WRITE
NAME	EQU	PARAMS+8	;OD----ADDRESS OF FILENAME BUFFER
ADDRS	EQU	PARAMS+8	;RW----ADDRESS OF RECORD TO READ OR WRITE 
ERROR	EQU	PARAMS+10	;ALL---ERROR RETURN CODE
STAT	EQU	PARAMS+12	;ALL---FILE STATUS BUFFER ADDRESS
TSL	EQU	PARAMS+14	;OCRWD-TSL BUFFER ADDRESS
DATA	EQU	PARAMS+16	;OCRW--DATA BUFFER ADDRESS (SECTOR)

;FILE MANAGER CALLS
FMOPEN	EQU	$01
FMCLOSE	EQU	$02
FMREAD	EQU	$03
FMWRITE	EQU	$04
FMDEL	EQU	$05
FMPOS	EQU	$0A

;FILE PARAMETERS

;OPEN FOR READ OR WRITE
OPEN:	DB	$01	;OPEN
	DB	$00	;X
	DW	$0000	;SEQUENTIAL
	DB	$00	;ANY VOLUME
	DB	$01	;DRIVE 1
	DB	$06	;SLOT 6
	DB	$20	;A-TYPE FILE
	DW	NAME	;ADDRESS OF FILE NAME BUFFER
	DB	$00	;SPACE FOR ERROR CODE
	DB	$00	;X
	DW	STAT
	DW	TSL
	DW	DATA

READ
	DB	$03
	DB	$01	;RANGE MODE
	DW	$0000	;SEQUENTIAL
ROFF:	DW	$0000	;SET BYTE OFFSET IN CALL
RRANGE:	DW	$0000	;SET RANGE IN CALL
RADDR:	DW	$0000	;SET ADDRESS IN CALL
	DB	$00	;FOR RETURN CODE
	DB	$00	;X
	DW	STAT
	DW	TSL
	DW	DATA

WRITE	
	DB	$04
	DB	$01	;RANGE MODE
	DW	$0000	;SEQUENTIAL
WOFF:	DW	$0000	;SET BYTE OFFSET IN CALL
WRANGE:	DW	$0000	;SET RANGE IN CALL
WADDR:	DW	$0000	;SET ADDRESS IN CALL
	DB	$00	;FOR RETURN CODE
	DB	$00	;X
	DW	STAT
	DW	TSL
	DW	DATA

CLOSE
	DB	$02
	DB	0,0,0,0, 0,0,0,0, 0,0,0
	DW	STAT
	DW	TSL
	DW	DATA

DELETE
	DB	$05
	DB	0,0,0
	DB	$00	;ANY VOLUME
	DB	$01	;DRIVE 1
	DB	$06	;SLOT 6
	DB	0	;X
	DW	NAME
	DB	$00	;FOR RETURN CODE
	DB	0	;X
	DW	STAT
	DW	TSL
	DW	DATA

POSITION
	DB	$0A
	DB	0	;X
	DW	$0000	;SEQUENTIAL
POFF	DW	$0000	;SET OFFSET IN CALL
	DB	0,0,0,0
	DB	$00	;FOR RETURN CODE
	DB	0
	DW	STAT
	DW	0,0

;SYSTEM ADDRESSES
ROMIN	EQU	$C082	;SELECT MONITOR ROM
ROMOUT	EQU	$C08B	;SELECT RAM FOR WS.  READ TWICE FOR WRITE ENABLE
BANK2	EQU	$C083	;SELECT 4K BANK SELECT RAM.  ONCE FOR READ ONLY
CSW	EQU	$0036	;OUTPUT HOOK
BELL	EQU	$FBDD	;BEEP, 1000 Hz
FILEM	EQU	$03D6	;FILE MANAGER, DOS 3.3 SYSTEM CALL
FBUF	EQU	$FD00	;POINTS TO FIRST FILE BUFFER
FNUM	EQU	$AA57	;SET TO MAXIMUM NUMBER OF FILE BUFFERS
MAXF	EQU	$A2F1	;CALL TO SET MAXFILES
GETIOB	EQU	$03E3	;GET IO PARAMETER BLOCK FOR RWTS
IOB	EQU	$048	;ADDRESS OF IOB
RWTS	EQU	$03D9	;READ/WRITE BY TRACK AND SECTOR

;ASCII CHARACTER CONSTANTS
BS	EQU	$OB
LF	EQU	$0A
CR	EQU	$0D
ESC	EQU	$1B
SPACE	EQU	$20

; OTHER CONSTANTS
MAXROW	EQU	23
MAXCOL	EQU	39


; DEGO VERSION NUMBER

DEF	VERS	3


; PRIMITIVE CODES

;DEF	NOP	$00
;DEF	ADD	$02
;DEF	BAND	$04
;DEF	BNOT	$06
;DEF	BOR	$08
;DEF	BXOR	$0A
;DEF	DEC	$0C
;DEF	DECDEC	$0E
;DEF	DOUBLE	$10
;DEF	DUP	$12
;DEF	EQ	$14
;DEF	EZ	$16
;DEF	FILL	$18
;DEF	GET	$1A
;DEF	GT	$1C
;DEF	GZ	$1E
;DEF	HALF	$20
;DEF	INC	$22
;DEF	INCINC	$24
;DEF	LAND	$26
;DEF	LBYTE	$28
;DEF	LD	$2A
;DEF	LDB	$2C
;DEF	LOR	$2E
;DEF	LT	$30
;DEF	LXOR	$32
;DEF	LZ	$34
;DEF	MOVE	$36
;DEF	NE	$38
;DEF	NEG	$3A
;DEF	NZ	$3C
;DEF	OVER	$3E
;DEF	POP	$40
;DEF	PUT	$42
;DEF	ROT	$44
;DEF	STO	$46
;DEF	STOB	$48
;DEF	STON	$4A
;DEF	STONB	$4C
;DEF	STOZ	$4E
;DEF	STOZB	$50
;DEF	SUB	$52
;DEF	SWAB	$54
;DEF	SWAP	$56
;DEF	WADD	$58
;DEF	WSIZE	$5A
;DEF	ESCAPE	$5C
;DEF	MCALL	$5E
;DEF	EXIT	$60
;DEF	FOPENR	$62
;DEF	FOPENW	$64
;DEF	FREAD	$66
;DEF	FWRITE	$68
;DEF	FCLOSE	$6A
;DEF	FREADR	$6C
;DEF	PRINT	$6E
;DEF	MSG	$70
;DEF	FERASE	$72
;DEF	FDIR	$74
;DEF	MUL	$76
;DEF	DIV	$78

	;SPECIAL INSTRUCTION CODES

;DEF	JU	$80
;DEF	JT	$82
;DEF	JF	$84
;DEF	JD	$86
;DEF	IPUSH	$88
;DEF	IPOP	$8A
;DEF	RETURN	$8C
;DEF	JLONG	$8E
;DEF	PUSH0	$90
;DEF	PUSH1	$92
;DEF	PUSHW	$94
;DEF	PUSHB	$96
;DEF	PUSHIZ	$98
;DEF	LDI	$9A
;DEF	LDBI	$9C
;DEF	STOI	$9E
;DEF	STOBI	$A0
;DEF	PUSHM1	$A2
;DEF	PUSH2	$A4
;DEF	PUSHIN	$A6


; MEMORY MAP MACROS
MACRO	ROM(X)
MACRO	DATA(X)
MACRO	WS(X)

; APL DISPLAY TABLE

DTABLE	DB	  0,169,169,169,169,169,169,169
	DB	  8,169,169,169,169, 13,169,169
	DB	169,169,169,169,169,169,169,169
	DB	169,169,169,169,169,169,169,169

	DB	 32, 33, 34, 35, 36, 37, 38, 39
	DB	 40, 41, 42, 43, 44, 45, 46, 47
	DB	 48, 49, 50, 51, 52, 53, 54, 55
	DB	 56, 57, 58, 59, 60, 61, 62, 63

	DB	 64, 65, 66, 67, 68, 69, 70, 71
	DB	 72, 73, 74, 75, 76, 77, 78, 79
	DB	 80, 81, 82, 83, 84, 85, 86, 87
	DB	 88, 89, 90, 91, 92, 93, 94, 95

	DB	 96, 97, 98, 99,100,101,102,103
	DB	104,105,106,107,108,109,110,111
	DB	112,113,114,115,116,117,118,119
	DB	120,121,122,123,124,125,126,169

	DB	 19,  5,  4,252, 11, 14,239, 29
	DB	 28, 21, 22,227,228,  3, 18,172
	DB	159,170,171,240,  2,155,156,169
	DB	169,169,169,169,169,169,169,169

	DB	224, 25,  6, 26, 24,250,229, 94
	DB	234,249,237, 15,232,236, 31, 30
	DB	246,238,242,226,248,243,146,134
	DB	253,149,152,151,251,166,143,141

	DB	241,169,169,169,169,169,169,169
	DB	169,169,169,169,169,169,169,169
	DB	169,169,169,169,169,169,169,169
	DB	169,169,169,230,245,231,244,254

	DB	145,169,169,169,169,169,169,169
	DB	169,169,169,169,169,169,169,169
	DB	169,169,169,169,169,169,169,169
	DB	169,169,169,235,167,233,158, 23

; MESSAGE TABLE

MSGS:	DB	'WHAT',0
	DB	'.SYNTAX',0
	DB	'INCORRECT COMMAND',0
	DB	'.DEFN',0
	DB	'.NONCE',0
	DB	'WS FULL',0
	DB	'.LIMIT',0
	DB	'.VALUE',0
	DB	'.DOMAIN',0
	DB	'.RANK',0
	DB	'.LENGTH',0
	DB	'.EXECUTE',0
	DB	'NOT SAVED',0
	DB	'NOT LOADED',0
	DB	' ERROR',0
	DB	'39',0
	DB	'CLEAR WS',0
	DB	'CLEAR',0
	DB	'FNS',0
	DB	'VARS',0
	DB	'SI',0
	DB	'SINL',0
	DB	'WSID',0
	DB	'ERASE',0
	DB	'SIC',0
	DB	'LIB',0
	DB	'LOAD',0
	DB	'SAVE',0
	DB	'COPY',0
	DB	'DROP',0
	DB	'OFF',0
	DB	'NOT FOUND',0
	DB	'I-APL LTD',0
	DB	'2 BLENHEIM ROAD',0
	DB	'ST ALBANS, HERTS, ENGLAND',0
	DB	'.AXIS',0
	DB	'.INDEX',0
	DB	'.DIRECT',0
	DB	'NOT FOUND',0
	DB	0
EXT	DB	'SWI.'	;BACKWARDS FOR INDEXING TOWARD 0

; JUMP TABLE
					;create a macro to intersperse
					;ICALLs
TABLE	DW	LNOP,	LADD,	LBAND,	LBNOT		;0
	DW	LBOR,	LBXOR,	LDEC,	LDECDEC		
	DW	LDOUBLE,LDUP,	LEQ,	LEZ		;10		
	DW	LFILL,	LGET,	LGT,	LGZ		
	DW	LHALF,	LINC,	LINCINC,LLAND		;20
	DW	LLBYTE, LLD,	LLDB,	LLOR		
	DW	LLT,	LLXOR,	LLZ,	LMOVE		;30
	DW	LNE,	LNEG,	LNZ,	LOVER		
	DW	LPOP,	LPUT,	LROT,	LSTO		;40
	DW	LSTOB,	LSTON,	LSTONB,	LSTOZ		
	DW	LSTOZB,	LSUB,	LSWAB,	LSWAP		;50
	DW	LWADD,	LWSIZE,	LESCAPE,LMCALL		
	DW	LEXIT,	LFOPENR,LFOPENW,LFREAD		;60
	DW	LFWRITE,LFCLOSE,LFREADR,LPRINT		
	DW	LMSG,	LFERASE,LFDIR,	LMUL		;70
	DW	LDIV,	DADD,	LNOP,	LNOP,		
	DW	LJU,	LJT,	LJF,	LJD		;80
	DW	LIPUSH,	LIPOP,	LRETURN,LJLONG		
	DW	LPUSH0,	LPUSH1,	LPUSHW,	LPUSHB		;90
	DW	LPUSHIZ,LLDI,	LLDBI,	LSTOI		
	DW	LSTOBI,	LPUSHM1,LPUSH2,	LPUSHIN		;A0
	DW	CASE,	DUPJF,	LLDNEXT,JPUSH		
	DW	LPOPPOP,LSWAPOP,LOVOVER,LEQI		;B0
	DW	LLDJ,	LSWOVER,LDUPLD,	LDUPSTI		
	DW	LDUPJT,	LDUPEQI,LDUPLBY,LDUPLDB		;C0
	DW	DUPLDNX,DUPDUP,	JU1,	RET0		
	DW	LADDI,	RET1,	ROTROT,	MOVE5		;D0
	DW	LNOP,	LNOP,	LNOP,	LNOP		
	DW	LSKIP1,	LSKIP2,	LSKIP3,	LSKIP4		;E0
	DW	LSKIP5,	LSKIP6,	LSKIP7,	LSKIP8		
	DW	LSKIPF1,LSKIPF2,LSKIPF3,LSKIPF4		;F0
	DW	LSKIPF5,LSKIPF6,LSKIPF7,LSKIPF8		

; SUBROUTINE TO BUILD FILE NAME--ADDS '.IWS' SUFFIX.  LENGTH OF FILENAME
; IS NO MORE THAN 8 CHARACTERS
ADDIWS:	LDA	SPACE
	STA	FNAME+8
	LDY	$#00
	BEQ	ADDIWS2
ADDIWS1:INY
ADDIWS2:LDA	FNAME,Y
	CMP	SPACE
	BNE	ADDIWS1
	LDX	#$03
ADDIWS3:LDA	EXT,X
	STA	FNAME,Y
	INY
	DEX
	BPL	ADDIWS3
	RTS

; SUBROUTINE TO COPY FILENAME TO BUFFER
; ADDRESS OF NAME IS ON STACK.  FILENAME IS 8 CHARACTERS OR LESS, WITH BLANK
; FILL
COPYFN:	LDA	VS
	STA	SCRATCH
	LDA	VS+1
	STA	SCRATCH+1
	LDY	#$07
COPYFN1:LDA	(SCRATCH),Y
	DEY
	CMP	SPACE
	BEQ	COPYFN1
COPYFN2:LDA	(SCRATCH),Y
	STA	FNAME,Y
	DEY
	BPL	COPYFN2
	RTS


; MAIN ROUTINE
IAPL:
;	DEFINE VARIABLES

;	GET FILENAME
;	TEST--REPORT ERROR IF NONE OR INVALID
;	READ PARAMETERS AND CODE FILE

;	SET UP MEMORY AND REGISTERS
;	SET FILE BUFFERS
	LDA	#1	;NUMBER OF FILE BUFFERS
	STA	FNUM
	JSR	MAXF	;SET MAXFILES

	LDA	#>FNAME	;FILE BUFFER POINTER
	STA	FBUF
	STA	NAME
	LDA	#<FNAME
	STA	FBUF+1
	STA	NAME+1

	LDA	#>BUFFER
	STA	BUFP
	STA	DATA
	LDA	#<BUFFER
	STA	BUFP+1
	STA	DATA+1

	LDA	#>FTSL
	STA	TSLP
	STA	TSL
	LDA	#<FTSL
	STA	TSLP+1
	STA	TSL+1

	LDA	#>FSTAT
	STA	STATP
	STA	STAT
	LDA	#<FSTAT
	STA	STATP+1
	STA	STAT+1

;SET UP IOB
	JSR	GETIOB
	STY	IOB
	STA	IOB+1
	LDY	$#03		;VOLUME
	LDA	$#00		;0
	STA	(IOB),Y
	LDY	$#08		;BUFFER ADDRESS
	LDA	#>BUFFER
	STA	(IOB),Y
	INY
	LDA	#<BUFFER
	STA	(IOB),Y
	LDY	#$0B		;NUMBER OF BYTES
	LDA	#$00		;FULL SECTOR
	STA	(IOB),Y
	INY			;COMMAND
	LDA	#$01		;READ SECTOR
	STA	(IOB),Y

;COPY IOB PARAMETERS TO FILE MANAGER PARAMETER LISTS--THUS I-APL CAN USE ANY
;SINGLE DRIVE SET FROM DOS.  SETTING VOLUME TO 0 ALLOWS CHANGING DISKETTES
;FREELY
	;SLOT
	LDY	#$01
	LDA	(IOB),Y
	STA	OPEN+6
	STA	DELETE+6
	;DRIVE
	INY
	LDA	(IOB),Y
	STA	OPEN+5
	STA	DELETE+5
	;VOLUME
	INY
	LDA	#$00
	STA	OPEN+4
	STA	DELETE+4

;SET OUTPUT HOOK FOR PRINTER IN SLOT 3
	LDA	#$00
	STA	CSW
	LDA	#$C3
	STA	CSW+1
;BEGIN EXECUTION
	JMP	ILOOP

;	INNER INTERPRETER Version 0

ICALL:	PHA
	LDA	(IP),Y
	TAX
	INC	IP
	BNE	ICALL1
	INC	IP+1
ICALL1:	LDA	IP+1
	DEC	RS
	STA	(RS),Y
	LDA	IP
	DEC	RS
	STA	(RS),Y
	TXA
	LNR	A
	TAX
	PLA
	ROR	A
	STA	IP
	TXA
	ADC	#ROMOFF
	STA	IP+1
LNOP:	
ILOOP:	LDY	#0
	LDA	(IP),Y
	INC	IP
	BNE	ILOOP1
	INC	IP+1
ILOOP1:	BIT	#1
	BNE	ICALL
	TAY
	LDA	(MCALL),Y
	STA	JUMP
	INY
	LDA	(MCALL),Y
	STA	JUMP+1
	JMP	(JUMP)

;INNER INTERPRETER Version 1 following Tony Cheal
;What is IPH for?

PUSH0:	LDA	TS+1			;move top of stack to machine stack
	PHA
	LDA	TS
	PHA
ZERO:	STY	TS			;store zero on top of stack
ZTOP:	STY	TS+1			;set high byte zero on stack
LNOP:
ILOOP:	LDA	(IP),Y			;get opcode
	STA	JUMP+1			;prepare indirect jump
	LSR	A			;test byte--op code or address
	BCS	ICALL			;address--stack and call
					;opcode--execute primitive
	INC	IP			;point to next code
	BNE	JUMP
	INC	IP+1
JUMP:	JMP	(TABLE)			;jump through table--SELF MODIFIED

ICALL:	DEC	RS			;stack return address
	LDA	IP+1
	STA	(RS),Y
	DEC	RS
	LDA	IP
	STA	(RS),Y

	LDA	(IP),Y			;get opcode again
	TAX				;stash--it has to be rotated last
	INC	IP			;point to high byte
	BNE	ICALL1
	INC	IP+1
ICALL1:	LDA	(IP),Y			;get high byte of address
	LSR	A			;start address shift
	STA	IP+1
	TXA				;low byte again
	ROR	A			;finish shift
	STA	IP

	LDA	IP+1			;get high byte again
	CMP	LIMIT			;section 1 or 2 of ROM
	BCS	OVER			;carry set=over limit
	ADC	ROM1			;carry is clear
	STA	IP+1
	JMP	ILOOP			;section 1
OVER:	ADC	ROM2			;carry is set, ROM2 is predecremented
	STA	IP+1
	JMP	ILOOP
;end of inner interpreter

	

;MACHINE LANGUAGE ROUTINES

;LNOP:				see above at ILOOP; no code needed

LADD:
	CLC
	PLA
	ADC	TS
	STA	TS
	PLA
	ADC	TS+1
	STA	TS+1
	JMP	ILOOP

LSUB:	SEC
	PLA
	SBC	TS
	STA	TS
	PLA
	SBC	TS+1
	STA	TS+1
	JMP	ILOOP

LNEG:	SEC
	TYA
	SBC	TS
	STA	TS
	TYA
	SBC	TS+1
	STA	TS+1
	JMP	ILOOP

LBAND:	PLA
	AND	TS
	STA	TS
	PLA
	AND	TS+1
	STA	TS+1
	JMP	ILOOP

LBNOT:	LDA	TS
	EOR	#$FF
	STA	TS
	LDA	TS+1
	EOR	$#FF
	STA	TS+1
	JMP	ILOOP

LBOR:	PLA
	ORA	TS
	STA	TS
	PLA
	ORA	TS+1
	STA	TS+1
	JMP	ILOOP

LBXOR:	PLA
	EOR	TS
	STA	TS
	PLA
	EOR	TS+1
	STA	TS+1
	JMP	ILOOP

LDECDEC:LDA	TS
	BNE	LDEC1
	DEC	TS+1
LDECDC1:DEC	TS
	JMP	ILOOP			;falls through

LDEC:	LDA	TS
	BNE	LDEC1
	DEC	TS+1
LDEC1:	DEC	TS
	JMP	ILOOP

LDOUBLE:ASL	TS
	ROL	TS+1
	JMP	ILOOP

LHALF:	LDA	TS+1			;get sign in carry
	ASL	A
	ROR	TS+1			;now shift right
	ROR	TS
	JMP	ILOOP

LDUP:	LDA	TS+1
	PHA
	LDA	TS
	PHA
	JMP	ILOOP

LFILL:

LGET:	;327
	LDA	#$00
	PHA
	LDA	$C000
	BPL	LGET
	BIT	$C010
	AND	#$7F
	PHA
	JMP	ILOOP

LINCINC:INC	TS
	BNE	LINCIN1
	INC	TS+1
LINCIN1:				;falls through

LINC:	INC	TS
	BNE	LINC1
	INC	TS+1
	JMP	ILOOP

LLAND:	PLA
	BNE	LLAND1
	PLA
	BNE	LLAND2
	JMP	ZERO
LLAND1:	PLA
LLAND2:	LDA	TS
	ORA	TS+1
	BNE	UNOJ
	JMP	ILOOP

LLOR:	PLA
	BNE	POPUN0
	PLA
	BNE	UNOJ			;fall through

LLNZ:	LDA	TS
	ORA	TS+1
	BNE	UNOJ
	JMP	ILOOP

POPUNO:	PLA				;used in LLOR, LLAND, LLXOR, LGZ,
UNOJ:	LDA	#1			;LLZ, LEQ
	STA	TS
	JMP	ZTOP

LLXOR:	PLA
	BNE	LLXOR1
	PLA
	BNE	LLXOR2
	LDA	TS			;y is zero
	ORA	TS+1
	BNE	UNOJ			;x is not zero, result is 1
	JMP	ILOOP			;x is zero, result is 0
LLXOR1:	PLA
LLXOR2:					;fall through

LEZ:	LDA	TS
	ORA	TS+1
	BEQ	UNOJ
	JMP	ZERO

LGZ:	LDA	TS+1
	BMI	ZEROJ
	ORA	TS
	BNE	UNOJ
	JMP	ILOOP

LLZ:	LDA	TS+1
	BMI	UNOJ
ZEROJ:	JMP	ZERO

LEQ:	PLA
	CMP	TS
	BNE	LEQ1
	PLA
	CMP	TS+1
	BNE	LEQ2
UNOJ1:	LDA	#1
	STA	TS
	JMP	ZTOP
LEQ1:	PLA
LEQ2:	JMP	ZERO

LLNE:	PLA
	CMP	TS
	BNE	POPUNO
	PLA
	CMP	TS+1
	BNE	UNOJ
	JMP	ZERO

LGT:	PLA				;check this logic--learn something
	CMP	TS
	BEQ	GTEQ
	PLA				;low bytes unequal
	SBC	TS+1
GTNE:	BVS	GTV
	BPL	UNOJ1			;no overflow--if positive, 1
	JMP	ZERO			;not positive--0
GTV:	BMI	UNOJ1			;overflow--if negative, 1
	JMP	ZERO			;not negative--0
GTEQ:	PLA				;low bytes equal
	SBC	TS+1
	BNE	GTNE			;high bytes unequal; test again
	JMP	ZERO			;high bytes equal; 0

LLT:	PLA
	CMP	TS
	PLA
	SBC	TS+1
	BVS	LLT1
	BMI	UNOJ1			;no overflow--minus, 1
	JMP	ZERO			;not minus, 0
LLT1:	BPL	UNOJ1			;overflow--plus, 1
	JMP	ZERO			;not plus, 0


LLBYTE:	LDA	TS+1
	BEQ	UNOJ1
ZEROJ2:	JMP	ZERO

SWAB:	LDA	TS
	LDX	TS+1
	STX	TS
	STA	TS+1
	JMP	ILOOP

LDUP:	LDA	TS+1
	PHA
	LDA	TS
	PHA
	JMP	ILOOP

LIPUSH:	DEC	RS
	LDA	TS+1
	STA	(RS),Y
	DEC	RS
	LDA	TS
	STA	(RS),Y
	PLA
	STA	TS
	PLA
	STA	TS+1
	JMP	ILOOP

LIPOP:	INC	RS
	INC	RS
	JMP	ILOOP

LRET0:	LDA	TS+1
	PHA
	LDA	TS
	PHA
	STY	TS
	STY	TS+1			;fall through

LRETURN:LDA	(RS),Y
	INC	RS
	STA	IP
	LDA	(RS),Y
	INC	RS
	STA	IP+1
	INC	IP
	BNE	LRTRN1
	INC	IP+1
LRTRN1:	INC	IP
	BNE	LRTRN2
	INC	IP+1
LRTRN2:					;at this point, put in routine to
					;correct for broken memory map
					;use byte table to correct high
					;byte

LOVOVER:LDA	TS+1			;OVEROVER
	PHA
	LDA	TS
	PHA
	TSX
	LDA	$104,X			;stack is in second page.  get 
	PHA				;second word (third element)
	LDA	$103,X
	PHA
	JMP	ILOOP

LOVER:	LDA	TS+1
	PHA
	LDA	TS
	PHA
	TSX
	LDA	$103,X
	STA	TS
	LDA	$104,X
	STA	TS+1
	JMP	ILOOP

LSWAPP:	PLA
	PLA
	JMP	ILOOP






LPUT:	;P. 344:  GRAPHICS CHARACTERS
;	USES BYTE FOR ROW, BYTE FOR COLUMN, BYTE FOR CHARACTER, 256 x 7 BYTE
;	CHARACTER TABLE,WORDS FOR SCREEN1 AND SCREEN2 
;IF CHARACTER IS A CONTROL CHARACTER, EXECUTE SUBROUTINE.  OTHERWISE
;DISPLAY CHARACTER AT CURRENT POSITION.  INCREMENT COLUMN. IF COLUMN=40, SET
;COLUMN TO 0 AND INCREMENT ROW.  IF ROW = 24, SCROLL UP AND SET ROW TO 23.

;GET CHARACTER CODE
	PLA		;GET BB
	TAX
	PLA		;GET AA
	BEQ	LPUT1	;IF AA=0, RAW ASCII OUTPUT
	CMP	#$0D	;OTHERWISE, TEST FOR CONTROL CHARACTERS
	BEQ	NEWLINE
	CMP	#$08
	BEQ	BACK
			;PRINTABLE APL; OUTPUT BB
;ASSERT:  A IS IN RANGE 20-FF, AND IS NOT 7F
	BNE	LPUT2
LPUT1:	TXA
LPUT2:	JSR	DISPLAY
	JSR	ROWINC	
	JMP	ILOOP

;GRAPHICS SUBROUTINES
;	DISPLAY CHARACTER AT CURRENT POSITION
;	CHARACTER IS IN A, POSITION IN ROW AND COLUMN IN PAGE ZERO, CHARACTER
;	SHAPES START AT CTABLE.

FINDRC:
;LOOKUP ROW ADDRESS
	LDA	ROW
	ASL	A
	TAY
	LDA	ROWS,Y
	STA	SCREEN1
	LDA	ROWS+1,Y
	STA	SCREEN1+1
;ADD COLUMN OFFSET
	LDA	COL
	CLC
	ADC	SCREEN1
	STA	SCREEN1
	LDA	#0
	ADC	SCREEN1+1
	STA	SCREEN1
	RTS

;GET ADDRESS OF CHARACTER
FINDCH:	STA	ZCHAR
	LDA	#0
	STA	ZCHAR+1
	ASL	ZCHAR
	ROL	ZCHAR+1
	ASL	ZCHAR
	ROL	ZCHAR+1
	ASL	ZCHAR
	ROL	ZCHAR+1
	CLC
	LDA	ZCHAR
	ADC	#>CHAR
	STA	ZCHAR
	LDA	ZCHAR+1
	ADC	#<CHAR
	STA	ZCHAR+1
	RTS

;DISPLAY THE CHARACTER
DISPLAY:JSR	FINDCH
	JSR	FINDRC
	LDX	#0
	LDY	#0
	BEQ	HCHAR1
HCHAR2	CLC
	LDA	SCREEN1+1
	ADC	#4
	STA	SCREEN1+1
HCHAR1	LDA	(ZCHAR),Y
	STA	(SCREEN1,X)
	INY
	CPY	#8
	BEQ	HCHAR2
	RTS

CURSOR:	;INVERT CHARACTER AT SCREEN LOCATION
	JSR	FINDRC
	LDX	#0
	LDY	#0
	BEQ	CURSOR1
CURSOR2:CLC
	LDA	SCREEN1+1
	ADC	#4
	STA	SCREEN1+1
CURSOR1:LDA	(SCREEN1,X)
	EOR	#$FF
	STA	(SCREEN1,X)
	INY
	CPY	#8
	BEQ	CURSOR2
	RTS
	
;TABLE OF HIRES ROW ADDRESSES
ROWS	DW	$2000	ROW  0
	DW	$2080	ROW  1
	DW	$2100	ROW  2
	DW	$2180	ROW  3
	DW	$2200	ROW  4
	DW	$2280	ROW  5
	DW	$2300	ROW  6
	DW	$2380	ROW  7
	DW	$2028	ROW  8
	DW	$20A8	ROW  9
	DW	$2128	ROW 10
	DW	$21A8	ROW 11
	DW	$2228	ROW 12
	DW	$22A8	ROW 13
	DW	$2328	ROW 14
	DW	$23A8	ROW 15
	DW	$2050	ROW 16
	DW	$20D0	ROW 17
	DW	$2150	ROW 18
	DW	$21D0	ROW 19
	DW	$2250	ROW 20
	DW	$22D0	ROW 21
	DW	$2350	ROW 22
	DW	$23D0	ROW 23


;	MOVE CURSOR TO NEXT
ROWINC:	LDA	COL
	CLC
	ADC	#$01
	CMP	#$28
	BEQ	COLINC
	STA	COL
	RTS
COLINC:	LDA	#$00
	STA	COL
	LDA	ROW
	CLC
	ADC	#$01
	CMP	$#18
	BEQ	SCROLL
	STA	ROW
	RTS

SCROLL:
;INITIALIZE
	LDA	#0
	STA	ROW
	LDA	#39
	STA	COL
	JSR	LOOKUP
;NEXT ROW TO MOVE
NXTROW:	INC	ROW
	LDA	$24
	CMP	ROW
	BEQ	LAST
;SET SCREEN REGISTERS
	LDA	SCREEN1
	STA	SCREEN2
	LDA	SCREEN1+1
	STA	SCREEN2+1
	JSR	LOOKUP
	JMP	LINE
;NEXT CHARACTER
NXTCHR:	INC	SCREEN1
	INC	SCREEN2

;NEXT LINE--INNER LOOP
LINE:	LDX	#0
	LDY	#0
	BEQ	SCROLL1
SCROLL2:CLC
	LDA	SCREEN1+1
	ADC	#4
	STA	SCREEN1+1
	LDA	SCREEN2+1
	ADC	#4
	STA	SCREEN2+1
SCROLL1:LDA	(SCREEN1,X)
	STA	(SCREEN2,X)
	INY
	CPY	#8
	BEQ	SCROLL2
;END CHARACTER
	DEC	COL
	BPL	NXTCHR
	
;END ROW
	JMP	NXTROW
LAST:	LDA	#23
	STA	ROW
	LDA	#0
	STA	COL
LAST1:	LDA	SPACE
	JSR	DISPLAY
	INC	COL
	LDA	#40
	CMP	COL
	BNE	LAST1
;END SCREEN
	RTS


;FOR I=0 TO 22
;	FOR J=0 TO 7
;		FOR K=0 TO 39
;			M[ROWS[I]+(1024xJ)+K]=	M[ROWS[I+1]+1024xJ)+K]
;NEXT K;NEXT J;NEXT I
	
;	MOVE CURSOR TO PREVIOUS
COLDEC:	LDA	COL
	BEQ	ROWDEC
	CLC
	ADC	#$FF
	STA	COL
	RTS
ROWDEC:	LDA	ROW
	BEQ	NOSCROL
	CLC
	ADC	#$FF
	STA	ROW
	LDY	#39
	STY	COL
	RTS
NOSCROL:JSR	BEEP
	RTS
	
;	NEWLINE
NEWLINE:LDY	#39
	STA	COL
	JSR	COLINC
	RTS

;	DESTRUCTIVE BACKSPACE
BACK:	JSR	CURSOR
	LDA	COL
	BNE	BACK1
	LDA	ROW
	BEQ	BACK2
BACK1:	JSR	COLDEC
	LDA	SPACE
	JSR	DISPLAY
	JSR	CURSOR
	RTS
BACK2	JSR	BEEP
	JSR	CURSOR
	RTS	


BEEP:	;SWAP IN MONITOR, SEND CONTROL-G, SWAP OUT MONITOR
	BIT	ROMIN
	LDA	#$07
	JSR	COUT1
	BIT	ROMOUT	;READ TWICE FOR WRITABLE RAM
	BIT	ROMOUT
	RTS

;END OF SCREEN OUTPUT ROUTINES


LESCAPE:	;327
	BIT	$C000
	BPL	PUSH0	; MOVE CLOSE ENOUGH FOR BRANCH
	LDA	$C000
	CMP	$9B
	BEQ	PUSH1	; MOVE CLOSE ENOUGH FOR BRANCH
	BNE	PUSH0

LMCALL:

LEXIT:
			   ***********************
;			   * FILE PRIMITIVES 434 *
			   ***********************
;GENERAL PLAN--SET UP 12 BYTE PARAMETER BLOCK, PUT ADDRESS IN REGISTERS, CALL
FILE MANAGER, MOVE RETURNED DATA, PUSH RESULT
;SUBROUTINES

OK:	;PUSH 1 ON VALUE STACK
	LDX	#$01	;1 AT TOP
	STX	VS
	DEX
	STX	VS+1
	RTS

ERROR:	;PUSH 0 ON VALUE STACK
	LDX	#$00	;0 AT TOP
	STA	VS
	STA	VS+1
	RTS

;			      *** OPEN FILE ***
LFOPENR:JSR	COPYFN	;PUT FILE NAME IN BUFFER
	JSR	ADDIWS	;ADD EXTENSION
	LDX	#$00	;DON'T OPEN NEW FILE
LFOPEN:	LDA	#<OPEN
	LDY	#>OPEN
	JSR	FILEM
	BCS	ERROR
	LDA	#$01
	STA	POFF
	LDA	#$00
	STA	POFF+1
	LDA	#>POSITION
	LDY	#<POSITION
	JSR	FILEM
	BCS	ERROR

LFOPENW:JSR	COPYFN	;DELETE FILE OF THIS NAME, IF ANY
	JSR	ADDIWS
	LDA	#>DELETE
	LDY	#<DELETE
	JSR	FILEM
	BCS	ERROR
	LDX	$FF	;OPEN NEW FILE
	JMP	LFOPEN

LFREAD:
			;READ FIRST TWO BYTES OF FILE TO SCRATCH
	LDX	$01		;OFFSET=1
	STA	ROFF
	DEX
	STA	ROFF+1
	LDX	#$02		;RANGE=2
	STX	RRANGE
	DEX
	DEX
	STX	RRANGE+1
	LDA	#>SCRATCH	;DATA ADDRESS=SCRATCH
	STA	RADDR
	LDA	#<SCRATCH
	STA	RADDR
	LDA	#>READ
	LDY	#<READ
	JSR	FILEM
	BCS	ERROR
	
			;SUBTRACT FROM SECOND VALUE ON STACK, 
	SEC
	PLA		;GET >Y
	SBC	SCRATCH
	PLA		;GET <Y
	SBC	SCRATCH+1
	BCC	ERROR	;FILE IS TOO BIG FOR WS

			;IF ROOM, READ FILE TO ADDRESS ON TOP OF STACK

	LDA	SCRATCH	;LENGTH OF DATA TO READ
	STA	RRANGE
	LDA	SCRATCH+1
	STA	RRANGE+1
	LDA	VS	;GET ADDRESS
	STA	RADDR
	LDA	VS+1
	STA	RADDR+1
	LDA	#$03	;SET OFFSET TO 3
	STA	ROFF
	LDA	#$00
	STA	ROFF+1
	LDA	#>READ
	LDY	#<READ
	JSR	FILEM
	BCS	ERROR
	BCC	OK


LFWRITE:
		;WRITE FILE SIZE Y, THEN Y BYTES STARTING FROM ADDRESS X
	PLA			;FILE SIZE
	STA	SCRATCH
	PLA
	STA	SCRATCH+1
	LDA	#>SCRATCH	;DATA ADDRESS
	STA	WRANGE
	LDA	#<SCRATCH
	STA	WRANGE+1
	LDA	#$02		;RANGE=2
	STA	WRANGE
	LDA	#$00
	STA	WRANGE+1
	STA	WOFF+1		;OFFSET=1
	LDA	#$01
	STA	WOFF
	LDA	#<WRITE		;WRITE LENGTH
	LDY	#>WRITE
	JSR	FILEM
	BCS	ERROR
			;NOW WRITE DATA.  LENGTH IS AT SCRATCH, ADDRESS ON 
			;TOP OF STACK
	LDA	SCRATCH		;RANGE
	STA	WRANGE
	LDA	SCRATCH+1
	STA	WRANGE+1
	LDA	#$03		;OFFSET=3
	STA	WOFF
	LDA	#$00
	STA	WOFF+1
	LDA	VS		;ADDRESS FROM STACK
	STA	WADDR
	LDA	VS+1
	STA	WADDR+1
	LDA	#>WRITE
	LDY	#<WRITE
	JSR	FILEM
	BCS	ERROR
	BCC	OK

LFCLOSE:
		;CLOSE FILE
	LDA	#>CLOSE
	LDY	#<CLOSE
	JSR	FILEM
	LDA	VS
	PHA
	LDA	VS+1
	PHA
	BCS	ERROR
	BCC	OK

LFREADR:
		;POSITION TO Y, READ X BYTES TO ADDRESS Z
	PLA			;GET Y, POSITION
	STA	ROFF
	PLA
	STA	ROFF+1
	LDA	VS		;GET X, RANGE
	STA	RRANGE
	LDA	VS+1
	STA	RRANGE+1
	PLA			;GET Z,	ADDRESS
	STA	RADDR
	PLA
	STA	RADDR+1
	LDA	#>POSITION
	LDY	#<POSITION
	JSR	FILEM
	BCS	ERROR
	BCC	OK

FERASE:
		;DELETE FILE
	JSR	COPYFN
	JSR	ADDIWS
	LDA	#>DELETE
	LDY	#<DELETE
	JSR	FILEM
	LDA	VS
	PHA
	LDA	VS+1
	PHA
	BCS	ERROR
	BCC	OK


;		*** DIR *.IWS (FOR LIB FUNCTION) ***
;NOT SUPPORTED BY APPLE DOS 3.3.  THIS ROUTINE USES RWTS AND INTERPRETS THE
;DISK DIRECTORY ITSELF.  IT REQUIRES ONE STORAGE LOCATION TO SAVE THE CURRENT
;DIRECTORY POINTER.
;RWTS 446
;IOB  447
;VTOC 411
;DIR  412

			;SUBROUTINES
VTOC:
	;TRACK 17, SECTOR 0
	;SET UP IOB
	LDY	#$04		;TRACK
	LDA	#$11		;17
	STA	(IOB),Y
	INY			;SECTOR
	LDA	#$00		;0
	STA	(IOB),Y
	LDY	IOB
	LDA	IOB+1
	JSR	RWTS
	LDY	#$0D		;RETURN CODE
	BNE	ERROR
	RTS

NEXTDS:		;GIVEN VTOC OR DIRECTORY SECTOR IN BUFFER, GET NEXT DIRECTORY
		;SECTOR.  USES POINTER AT LOCATIONS 01.02 IN SECTOR
		;FORMAT:  BYTE 1=TRACK, BYTE 2=SECTOR?
	LDA	BUFFER+1
	BNE	NEXTDS1
	LDX	BUFFER+2
	BEQ	NEXTDS2
NEXTDS1	LDY	#$04		;TRACK
	STA	(IOB),Y
	INY			;SECTOR
	STX	(IOB),Y
	
NEXTDS2	;PUSH A ZERO
	JMP	ERROR
	
NXTFN:
ISWS:


FDIR:	;IF Y=0,
	PLA
	BNE	FDIR1
	PLA
	;READ VTOC



	;GET DIRECTORY SECTOR
	;WHILE NOT LAST SECTOR
	;GET NEXT FILE NAME
	
	;IF IT ENDS IN .IWS, COPY TO BUFFER, PUSH LENGTH

	;IF Y>0, CONTINUE SEARCH




LPRINT:		; OUTPUT HOOK CSW IS SET TO C300, FOR SLOT 3 PRINTER
		; 319,320 
	JSR	LPRINT1		;THE OUTPUT ROUTINE DOES RTS, SO IT MUST BE
	JUMP	ILOOP		;IN A SUBROUTINE
LPRINT1:JMP	(CSW)


;	END
