/******************************************************************/
/*																						*/
/*		includes																		*/
/*																						*/
/******************************************************************/

	/* include definitions of library functions */

#include <stdio.h>
#include <conio.h>
#include <memory.h>
#include <string.h>
#include <io.h>
#include <dos.h>

/******************************************************************/
/*																						*/
/*		literal definitions														*/
/*																						*/
/******************************************************************/

	/* DEGO version number */

#define VERS 3

	/* primitive codes */

#define NOP		0x00
#define ADD		0x02
#define BAND	0x04
#define BNOT	0x06
#define BOR		0x08
#define BXOR	0x0A
#define DEC		0x0C
#define DECDEC	0x0E
#define DOUBLE	0x10
#define DUP		0x12
#define EQ		0x14
#define EZ		0x16
#define FILL	0x18
#define GET		0x1A
#define GT		0x1C
#define GZ		0x1E
#define HALF	0x20
#define INC		0x22
#define INCINC	0x24
#define LAND	0x26
#define LBYTE	0x28
#define LD		0x2A
#define LDB		0x2C
#define LOR		0x2E
#define LT		0x30
#define LXOR	0x32
#define LZ		0x34
#define MOVE	0x36
#define NE		0x38
#define NEG		0x3A
#define NZ		0x3C
#define OVER	0x3E
#define POP		0x40
#define PUT		0x42
#define ROT		0x44
#define STO		0x46
#define STOB	0x48
#define STON	0x4A
#define STONB	0x4C
#define STOZ	0x4E
#define STOZB	0x50
#define SUB		0x52
#define SWAB	0x54
#define SWAP	0x56
#define WADD	0x58
#define WSIZE	0x5A
#define ESCAPE	0x5C
#define MCALL	0x5E
#define EXIT	0x60
#define FOPENR	0x62
#define FOPENW	0x64
#define FREAD	0x66
#define FWRITE	0x68
#define FCLOSE	0x6A
#define FREADR	0x6C
#define PRINT	0x6E
#define MSG		0x70
#define FERASE	0x72
#define FDIR	0x74
#define MUL		0x76
#define DIV		0x78
#define DADD	0x7A

	/* special instruction codes */

#define JU		0x80
#define JT		0x82
#define JF		0x84
#define JD		0x86
#define IPUSH	0x88
#define IPOP	0x8A
#define RETURN	0x8C
#define JLONG	0x8E
#define PUSH0	0x90
#define PUSH1	0x92
#define PUSHW	0x94
#define PUSHB	0x96
#define PUSHIZ	0x98
#define LDI		0x9A
#define LDBI	0x9C
#define STOI	0x9E
#define STOBI	0xA0
#define PUSHM1	0xA2
#define PUSH2	0xA4
#define PUSHIN	0xA6
#define CASE	0xA8
#define DUPJF	0xAA
#define LDNEXT	0xAC
#define JPUSH	0xAE
#define POPPOP	0xB0
#define SWAPOP	0xB2
#define OVOVER	0xB4
#define EQI		0xB6
#define LDJ		0xB8
#define SWOVER	0xBA
#define DUPLD	0xBC
#define DPSTI	0xBE
#define DUPJT	0xC0
#define DUPEQI	0xC2
#define DUPLBY	0xC4
#define DUPLDB	0xC6
#define DUPLDN	0xC8
#define DUPDUP	0xCA
#define JU1		0xCC
#define RET0	0xCE
#define ADDI	0xD0
#define RET1	0xD2
#define ROTROT	0xD4
#define MOVE5	0xD6

#define SKIP1	0xE0
#define SKIP2	0xE2
#define SKIP3	0xE4
#define SKIP4	0xE6
#define SKIP5	0xE8
#define SKIP6	0xEA
#define SKIP7	0xEC
#define SKIP8	0xEE
#define SKIPF1	0xF0
#define SKIPF2	0xF2
#define SKIPF3	0xF4
#define SKIPF4	0xF6
#define SKIPF5	0xF8
#define SKIPF6	0xFA
#define SKIPF7	0xFC
#define SKIPF8	0xFE

	/* ascii control characters */

#define BS	0x08
#define LF	0x0A
#define CR	0x0D
#define ESC	0x1B

#define DEL -83
#define CUL -75
#define CUR -77
#define HOME -71
#define END -79
#define CCUL -115
#define CCUR -116

	/* shorthand for unsigned char */

#define byte unsigned char

	/* simple memory mapping macros */
	/* ROM maps rom logical address to physical address */
	/* DATA maps data logical address to physical address */
	/* WS maps ws logical address to physical address */

#define ROM(x)		(rom + (x))
#define DATA(x)	(data + (x))
#define WS(x)		(ws + (x))

	/* composite memory mapping macros */
	/* RAM maps ram logical addr (data or ws) to physical addr */
	/* MEM maps any logical addr (rom, data or ws) to physical addr */

#define RAM(x)	((x) < 0 ? WS (x) : DATA (x))
#define MEM(x)	((x) < 0 ? WS (x) : (x) >= 0x800 ? ROM (x) : DATA (x))

	/* vstack argument words */

#define V	vs [-2]	/* new top value */
#define W	vs [-1]	/* new top value */
#define X	vs [0]	/* top value */
#define Y	vs [1]	/* second value */
#define Z	vs [2]	/* third value */

/******************************************************************/
/*																						*/
/*		arrays																		*/
/*																						*/
/******************************************************************/

	/* physical memory of 60000 bytes in this version */

#define MEMORY_SIZE 60000
char memory [MEMORY_SIZE];

	/* translation table to map to APL display character codes */
	/* disp_table [i] gives character code for #AV[i] */

byte disp_table [256] =
{
	0,		169,	169,	169,	169,	169,	169,	169,
	8,		169,	169,	169,	169,	13,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,

	32,	33,	34,	35,	36,	37,	38,	39,
	40,	41,	42,	43,	44,	45,	46,	47,
	48,	49,	50,	51,	52,	53,	54,	55,
	56,	57,	58,	59,	60,	61,	62,	63,

	64,	65,	66,	67,	68,	69,	70,	71,
	72,	73,	74,	75,	76,	77,	78,	79,
	80,	81,	82,	83,	84,	85,	86,	87,
	88,	89,	90,	91,	92,	93,	94,	95,

	96,	97,	98,	99,	100,	101,	102,	103,
	104,	105,	106,	107,	108,	109,	110,	111,
	112,	113,	114,	115,	116,	117,	118,	119,
	120,	121,	122,	123,	124,	125,	126,	169,

	19,	5,		4,		252,	11,	14,	239,	29,
	28,	21,	22,	227,	228,	3,		18,	172,
	159,	170,	171,	240,	2,		155,	156,	169,
	169,	169,	169,	169,	169,	169,	169,	169,

	224,	25,	6,		26,	24,	250,	229,	94,
	234,	249,	237,	15,	232,	236,	31,	30,
	246,	238,	242,	226,	248,	243,	146,	134,
	253,	149,	152,	151,	251,	166,	143,	141,

	241,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	230,	245,	231,	244,	254,

	145,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	169,	169,	169,	169,	169,
	169,	169,	169,	235,	167,	233,	158,	23
};

	/* msg table */
	/* msg_table [i] is ptr to msg i */

char *msg_table [] =
{
	"WHAT",
	".SYNTAX",
	"INCORRECT COMMAND",
	".DEFN",
	".NONCE",
	"WS FULL",
	".LIMIT",
	".VALUE",
	".DOMAIN",
	".RANK",
	".LENGTH",
	"NOT COPIED",
	"NOT SAVED",
	".DISK",
	"ERROR",
	"INTERRUPT",
	"NOT ERASED",
	".INDEX",
	".AXIS",
	"NOT FOUND",

	"THE FREE APL INTERPRETER",
	"VERSION",
	"SUPPLIED BY:",
	"I-APL LTD",
	"2 BLENHEIM ROAD",
	"ST ALBANS, HERTS, ENGLAND",
	"79",
	"CLEAR WS",
	"PC",
	"808X",
	"MSDOS",
	"TEXT",
	"PGHC"
};

	/* file name buffer */

char file_name_buffer [13];

	/* dos dta */

char dos_dta [128];		/* dos data transfer area */

	/* pointers to origins of logical address spaces */

char *rom, *data, *ws;

/******************************************************************/
/*																						*/
/*		procedures																	*/
/*																						*/
/******************************************************************/

	/* build file name (extension = .IWS) */

char *get_file_name (buffer) register char *buffer;
{
	register char *ptr = file_name_buffer;
	int i;

	for (i = 8; i && *buffer != ' '; i--) *ptr++ = *buffer++;
	*ptr = 0;
	return strcat (file_name_buffer, ".iws");
}

	/*	get file name in directory	*/

int fdir (x, y) int x, y;
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	unsigned int dta_seg, dta_offset;
	int found;
	char *sptr, *dptr;

	/* get current dta */

	inregs.h.ah = 0x2F;
	intdos (&inregs, &outregs);
	segread (&segregs);
	dta_seg = segregs.es;
	dta_offset = outregs.x.bx;

	/* set dta to dos_dta */

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* directory search */

	inregs.x.dx = (unsigned int) "*.IWS";
	inregs.h.ah = y ? 0x4F : 0x4E;
	intdosx (&inregs, &outregs, &segregs);

	found = !outregs.x.cflag;	/* file found */

	/* restore original dta */

	segregs.ds = dta_seg;
	inregs.x.dx = dta_offset;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

	/* copy file name to destination */

	y = 0;

	if (found) for (sptr = dos_dta + 30, dptr = RAM (x);
		*sptr != '.'; y++) *dptr++ = *sptr++;

	return y;
}

	/* top level routine */

void main (argc, argv) int argc; char *argv [];
{
	FILE *file;									/* file handle */
	int file_size;								/* file_size */

	int *rs;										/* return stack pointer */
	register int *vs;							/* value stack pointer */
	register char *ip;						/* instruction pointer */

	int vers;									/* compiler version number */
	int addr, rsize, vsize, dsize, csize;
													/* object file parameters */

	int ws_size;								/* workspace size */

	union REGS inregs, outregs;
	struct SREGS segregs;

	int temp, carry;
	char tempb;
	char *sptr, *dptr;
	long templ;

		/* set up dos dta */

	segread (&segregs);
	inregs.x.dx = (unsigned int) dos_dta;
	inregs.h.ah = 0x1A;
	intdosx (&inregs, &outregs, &segregs);

		/* open object code file */

	if (argc != 2)
	{
		printf ("No input file specified");
		return;
	}

	file = fopen (argv [1], "rb");

	if (!file)
	{
		printf ("Input file not found");
		return;
	}

		/* check version number */

	fread ((char *) &vers, 2, 1, file);
										/* DE compiler version number */

	if (vers != VERS)
	{
		fclose (file);
		printf ("Incorrect version number");
		return;
	}

		/* read object parameters and code */

	fread ((char *) &addr, 2, 1, file);		/* logical address of */
														/* level fn */
	fread ((char *) &rsize, 2, 1, file);	/* size of return stack */
	fread ((char *) &vsize, 2, 1, file);	/* size of value stack */
	fread ((char *) &dsize, 2, 1, file);	/* size of data */
	fread ((char *) &csize, 2, 1, file);	/* size of object code */

	fread (memory, 1, csize, file);			/* object code */

	fclose (file);

	file = 0;										/* no file open */

		/* set up memory pointers */

	rom = memory - 0x800;
	data = memory + csize - 0x0100;
	vs = (int *) (memory + csize + dsize + vsize);
	rs = (int *) (memory + csize + dsize + vsize + rsize);
	ws = memory + csize + dsize + rsize + vsize - 0x8000;

		/* set up ws size, ensuring it is even and positive */

	ws_size = (MEMORY_SIZE - csize - dsize - rsize - vsize) & 0xFFFE;
	if (ws_size < 0) ws_size = 32766;

		/* initial instruction pointer */

	ip = ROM (addr);

		/* main instruction loop */

	while (1)
	{
		if (*ip & 1)
		{
				/* CALL - push address of next instruction and set ip */

			*--rs = (int) ip + 2;
			ip = ROM (*(unsigned int *) ip / 2);
		}
		else
		{
				/* execute instruction code */

			switch ((byte) *ip++)
			{
				/* primitives */

			case BNOT:		X = ~X; break;
			case DEC:		X -= 1; break;
			case DECDEC:	X -= 2; break;
			case DOUBLE:	X <<= 1; break;
			case EZ:			X = !X; break;
			case GZ:			X = X > 0; break;
			case HALF:		X >>= 1; break;
			case INC:		X += 1; break;
			case INCINC:	X += 2; break;
			case LBYTE:		X = !(X & 0xFF00); break;
			case LZ:			X = X < 0; break;
			case NEG:		X = -X; break;
			case NZ:			X = X != 0; break;
			case SWAB:		X = (X << 8) | ((unsigned int) X >> 8);
								break;


			case ADD:		Y += X; vs += 1; break;
			case BAND:		Y &= X; vs += 1; break;
			case BOR:		Y |= X; vs += 1; break;
			case BXOR:		Y ^= X; vs += 1; break;
			case EQ:			Y = Y == X; vs += 1; break;
			case GT:			Y = Y > X; vs += 1; break;
			case LAND:		Y = Y && X; vs += 1; break;
			case LOR:		Y = Y || X; vs += 1; break;
			case LT:			Y = Y < X; vs += 1; break;
			case LXOR:		Y = (!Y) ^ (!X); vs += 1; break;
			case NE:			Y = Y != X; vs += 1; break;
			case SUB:		Y -= X; vs += 1; break;


			case MUL:		templ = (long) Y * (long) X;
								Y = (int) templ; X = (int) (templ >> 16);
								break;
			case DIV:		temp = Y % X; Y /= X;
								if (temp && (temp ^ X) < 0) Y -= 1,
								temp += X; X = temp; break;


			case DUP:		W = X; vs -= 1; break;
			case OVER:		W = Y; vs -= 1; break;
			case POP:		vs += 1; break;
			case ROT:		temp = X; X = Z; Z = Y; Y = temp; break;
			case SWAP:		temp = X; X = Y; Y = temp; break;


			case FILL:		if (X) memset (RAM (Y), Z, (unsigned int) X);
								vs += 3; break;
			case LD:			X = *(int *) MEM (X); break;
			case LDB:		X = (int) *(byte *) MEM (X); break;
			case MOVE:		if (X) memcpy (RAM (Y), MEM (Z),
								(unsigned int) X); vs += 3; break;
			case STO:		*(int *) RAM (X) = Y; vs += 2; break;
			case STOB:		*RAM (X) = (char) Y; vs += 2; break;
			case STON:		*(int *) RAM (X) = 1; vs += 1; break;
			case STONB:		*RAM (X) = 1; vs += 1; break;
			case STOZ:		*(int *) RAM (X) = 0; vs += 1; break;
			case STOZB:		*RAM (X) = 0; vs += 1; break;

			case DADD:		temp = X; sptr = MEM (Z + temp);
								dptr = RAM (Y + temp); carry = 0;
								while (temp--) tempb = *--sptr + *--dptr +
								(char) carry, *dptr = (carry = tempb >= 10) ?
								tempb - 10 : tempb; Z = carry; vs += 2;
								break;

			case GET:		if (!(temp = getch ())) temp = -getch ();
								W = temp == DEL ? 127 : temp == CUL ? 1 :
								temp == CUR ? 2 : temp == HOME ? 3 :
								temp == END ? 4 : temp == CCUL ? 5 :
								temp == CCUR ? 6 : temp; vs -= 1 ; break;
			case PUT:		if (X & 0xFF00) temp = (int)
								disp_table [(unsigned int) X >> 8],
								putch (temp), temp == CR ?
								fputc (LF, stdout) : 0;
								else putch (X); vs += 1; break;
			case ESCAPE:	temp = 0; while (kbhit ())
								temp |= getch () == ESC; W = temp; vs -= 1;
								break;
			case PRINT:		fputc (X & 0xFF, stdprn);
								if ((X & 0xFF00) && (char) X == CR)
								fputc (LF, stdprn); fflush (stdprn); vs += 1;
								break;


			case FOPENR:	if (file) fclose (file);
								X = (file = fopen (get_file_name (MEM (X)),
								"rb")) &&
								fread ((char *) &file_size, 2, 1, file);
								break;
			case FOPENW:	if (file) fclose (file);
								file = fopen (get_file_name (MEM (X)), "wb");
								file_size = 0; X = file != 0; break;
			case FREAD:		Y = file && !fseek (file, 2L, 0) &&
								file_size <= X && (file_size ?
								fread (RAM (Y), 1, file_size, file) ==
								file_size : 1); vs += 1; break;
			case FWRITE:	Y = file && !fseek (file, 0L, 0) &&
								fwrite ((char *) &X, 2, 1, file) &&
								(X ? fwrite (MEM (Y), 1, X, file) == X : 1);
								if (Y) file_size = X; vs += 1; break;
			case FCLOSE:	if (W = file != 0) W = !fclose (file);
								vs -= 1; break;
			case FREADR:	Z = file && X + Y <= file_size &&
								!fseek (file, (long) (Y + 2), 0) &&
								(X ? fread (RAM (Z), 1, X, file) == X : 1);
								vs += 2; break;
			case FERASE:	if (W = file != 0) if (W = !fclose (file))
								W = !unlink (file_name_buffer); vs -= 1;
								break;
			case FDIR:		Y = fdir (X, Y); vs += 1; break;


			case NOP:		break;
			case WADD:		X += 0x8000; break;
			case WSIZE:		W = ws_size; vs -= 1; break;
			case MCALL:		Z = 0; vs += 2; break;
			case EXIT:		return;
			case MSG:		if ((unsigned) Y < sizeof (msg_table) / 2)
								Y = (int) strlen (sptr = msg_table [Y]),
								memcpy (RAM (X), sptr, (unsigned int) Y);
								else Y = 0; vs += 1; break;



				/* special instructions */

			case JU:			ip += 1 + (int) (byte) *ip; break;
			case JT:			ip += X ? 1 + (int) (byte) *ip : 1; vs += 1;
								break;
			case JF:			ip += X ? 1 : 1 + (int) (byte) *ip; vs += 1;
								break;
			case JD:			ip += *rs ? ((*rs) -= 1,
								-255 + (int) (byte) *ip) : (rs += 1, 1);
								break;
			case IPUSH:		*--rs = X; vs += 1; break;
			case IPOP:		rs += 1; break;
			case RETURN:	ip = (char *) *rs++; break;
			case JLONG:		ip += 2 + *(int *) ip; break;
			case PUSH0:		W = 0; vs -= 1; break;
			case PUSH1:		W = 1; vs -= 1; break;
			case PUSHW:		W = *(int *) ip; vs -= 1; ip += 2; break;
			case PUSHB:		W = (int) (byte) *ip; vs -= 1; ip += 1;
								break;
			case PUSHIZ:	W = 0x0100 + (int) (byte) *ip; vs -= 1;
								ip += 1; break;
			case LDI:		W = *(int *)
								DATA (0x0100 + (int) (byte) *ip); vs -= 1;
								ip += 1; break;
			case LDBI:		W = (int) *(byte *)
								DATA (0x0100 + (int) (byte) *ip); vs -= 1;
								ip += 1; break;
			case STOI:		*(int *) DATA (0x0100 +
								(int) (byte) *ip) = X; vs += 1; ip += 1;
								break;
			case STOBI:		*DATA (0x0100 + (int) (byte) *ip) = (char) X;
								vs += 1; ip += 1; break;
			case PUSHM1:	W = -1; vs -= 1; break;
			case PUSH2:		W = 2; vs -= 1; break;
			case PUSHIN:	W = 0x0200 + (int) (byte) *ip; vs -= 1;
								ip += 1; break;
			case CASE:		temp = *(int *) (ip + 1 + (X << 1));
								ip += 1 + (int) *ip;
								if (temp) *--rs = (int) ip,
								ip = ROM ((unsigned int) temp >> 1); vs += 1;
								break;
			case DUPJF:		ip += X ? 1 : 1 + (int) (byte) *ip; break;
			case LDNEXT:	X = *(int *) MEM (X + 2); break;
			case JPUSH:		*--rs = X; ip += 1 + (int) (byte) *ip;
								vs += 1; break;
			case POPPOP:	vs += 2; break;
			case SWAPOP:	Y = X; vs += 1; break;
			case OVOVER:	W = Y; V = X; vs -= 2; break;
			case EQI:		X = X == (int) (byte) *ip; ip += 1; break;
			case LDJ:		W = *(int *)
								DATA (0x0200 + (int) (byte) *ip); vs -= 1;
								ip += 1; break;
			case SWOVER:	W = X; X = Y; Y = W; vs -= 1; break;
			case DUPLD:		W = *(int *) MEM (X); vs -= 1; break;

			case DPSTI:		*(int *) DATA (0x0100 +
								(int) (byte) *ip) = X; ip += 1; break;
			case DUPJT:		ip += X ? 1 + (int) (byte) *ip : 1; break;
			case DUPEQI:	W = X == (int) (byte) *ip; vs -= 1; ip += 1;
								break;
			case DUPLBY:	W = !(X & 0xFF00); vs -= 1; break;
			case DUPLDB:	W = (int) *(byte *) MEM (X); vs -= 1; break;
			case DUPLDN:	W = *(int *) MEM (X + 2); vs -= 1; break;
			case DUPDUP:	V = W = X; vs -= 2; break;
			case JU1:		W = 1; vs -= 1; ip += 1 + (int) (byte) *ip;
								break;
			case RET0:		W = 0; vs -= 1; ip = (char *) *rs++; break;
			case ADDI:		X = X + (int) (byte) *ip; ip += 1; break;
			case RET1:		W = 1; vs -= 1; ip = (char *) *rs++; break;
			case ROTROT:	temp = X; X = Y; Y = Z; Z = temp; break;
			case MOVE5:		memcpy (RAM (X), MEM (Y), 5); vs += 2; break;

			case SKIP1:
			case SKIP2:
			case SKIP3:
			case SKIP4:
			case SKIP5:
			case SKIP6:
			case SKIP7:
			case SKIP8:		ip += ((ip [-1] >> 1) & 7) + 1; break;

			case SKIPF1:
			case SKIPF2:
			case SKIPF3:
			case SKIPF4:
			case SKIPF5:
			case SKIPF6:
			case SKIPF7:
			case SKIPF8:	if (!X) ip += ((ip [-1] >> 1) & 7) + 1;
								vs += 1; break;
			}
		}
	}
}
                                                                                                                                                                                                              